/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.config;

import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.artifactory.common.MutableStatusHolder;
import org.artifactory.sapi.common.BaseSettings;
import org.slf4j.Logger;

public class ImportExportSettingsImpl
implements BaseSettings {
    private final File baseDir;
    private boolean includeMetadata = true;
    private boolean verbose;
    private boolean failFast;
    private boolean failIfEmpty;
    private Path archiveTempDir;
    protected boolean excludeContent;
    private MutableStatusHolder statusHolder;
    private boolean isEnableCopySecurityAccessDir = false;
    private List<String> repositories = Collections.emptyList();

    public ImportExportSettingsImpl(File baseDir, MutableStatusHolder statusHolder) {
        this.baseDir = baseDir;
        this.statusHolder = statusHolder;
    }

    public ImportExportSettingsImpl(File baseDir, BaseSettings baseSettings, MutableStatusHolder statusHolder) {
        this(baseDir, statusHolder);
        ImportExportSettingsImpl settings = (ImportExportSettingsImpl)baseSettings;
        this.includeMetadata = settings.includeMetadata;
        this.repositories = settings.repositories;
        this.verbose = settings.verbose;
        this.failFast = settings.failFast;
        this.failIfEmpty = settings.failIfEmpty;
        this.excludeContent = settings.excludeContent;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public boolean isIncludeMetadata() {
        return this.includeMetadata;
    }

    public void setIncludeMetadata(boolean includeMetadata) {
        this.includeMetadata = includeMetadata;
    }

    public List<String> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(List<String> repositories) {
        this.repositories = repositories;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        this.statusHolder.setVerbose(verbose);
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
        this.statusHolder.setFastFail(failFast);
    }

    public boolean isFailIfEmpty() {
        return this.failIfEmpty;
    }

    public void setFailIfEmpty(boolean failIfEmpty) {
        this.failIfEmpty = failIfEmpty;
    }

    public MutableStatusHolder getStatusHolder() {
        return this.statusHolder;
    }

    public boolean isExcludeContent() {
        return this.excludeContent;
    }

    public void setExcludeContent(boolean excludeContent) {
        this.excludeContent = excludeContent;
    }

    public void alertFailIfEmpty(String message, Logger log) {
        if (this.isFailIfEmpty()) {
            this.statusHolder.error(message, log);
        } else {
            this.statusHolder.warn(message, log);
        }
    }

    public void setEnableCopySecurityAccessDir(boolean enableCopySecurityAccessDir) {
        this.isEnableCopySecurityAccessDir = enableCopySecurityAccessDir;
    }

    public boolean isEnableCopySecurityAccessDir() {
        return this.isEnableCopySecurityAccessDir;
    }
}

