/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.bintray.distribution.reporting.model;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jfrog.bintray.client.api.details.PackageDetails;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.artifactory.api.bintray.BintrayUploadInfo;
import org.artifactory.api.bintray.distribution.reporting.model.BintrayVersionModel;

public class BintrayPackageModel {
    public String packageName;
    public Boolean created;
    public Set<String> licenses = Sets.newHashSet();
    public Map<String, BintrayVersionModel> versions = Maps.newHashMap();

    public BintrayPackageModel() {
    }

    public BintrayPackageModel(BintrayUploadInfo uploadInfo) {
        PackageDetails pkgDetails = uploadInfo.getPackageDetails();
        this.packageName = pkgDetails.getName();
        if (pkgDetails.getLicenses() != null) {
            this.licenses.addAll(pkgDetails.getLicenses());
        }
        this.versions.put(uploadInfo.getVersionDetails().getName(), new BintrayVersionModel(uploadInfo));
    }

    public void merge(BintrayPackageModel pkg) {
        this.licenses.addAll(pkg.licenses);
        pkg.versions.values().forEach(this::addVersion);
    }

    private void addVersion(BintrayVersionModel bintrayVersion) {
        BintrayVersionModel existingVersion = this.versions.get(bintrayVersion.versionName);
        if (existingVersion == null) {
            this.versions.put(bintrayVersion.versionName, bintrayVersion);
        } else {
            existingVersion.merge(bintrayVersion);
        }
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Boolean getCreated() {
        return this.created;
    }

    public Set<String> getLicenses() {
        return this.licenses;
    }

    public Collection<BintrayVersionModel> getVersions() {
        return this.versions.values();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BintrayPackageModel)) {
            return false;
        }
        BintrayPackageModel that = (BintrayPackageModel)o;
        return this.packageName != null ? this.packageName.equals(that.packageName) : that.packageName == null;
    }

    public int hashCode() {
        return this.packageName != null ? this.packageName.hashCode() : 0;
    }
}

