/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.addon.layouts.translate;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import org.artifactory.addon.layouts.translate.ChecksumTranslatorFilter;
import org.artifactory.addon.layouts.translate.MetadataTranslatorFilter;
import org.artifactory.addon.layouts.translate.TranslatorFilter;
import org.artifactory.api.common.BasicStatusHolder;
import org.artifactory.api.module.ModuleInfo;
import org.artifactory.api.module.ModuleInfoUtils;
import org.artifactory.descriptor.repo.RepoLayout;
import org.artifactory.util.RepoLayoutUtils;
import org.jfrog.security.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathTranslationHelper {
    private static final Logger log = LoggerFactory.getLogger(PathTranslationHelper.class);
    private TranslatorFilter[] translatorFilters = new TranslatorFilter[]{new ChecksumTranslatorFilter(), new MetadataTranslatorFilter()};

    public String translatePath(RepoLayout sourceRepoLayout, RepoLayout targetRepoLayout, String path, BasicStatusHolder multiStatusHolder) {
        ModuleInfo resultModuleInfo;
        String result;
        LinkedList filters = Lists.newLinkedList();
        path = this.filterPaths(path, filters);
        ModuleInfo moduleInfo = null;
        boolean descriptor = true;
        if (sourceRepoLayout.isDistinctiveDescriptorPathPattern()) {
            moduleInfo = ModuleInfoUtils.moduleInfoFromDescriptorPath(path, sourceRepoLayout);
        }
        if (moduleInfo == null || !moduleInfo.isValid()) {
            moduleInfo = ModuleInfoUtils.moduleInfoFromArtifactPath(path, sourceRepoLayout);
            descriptor = false;
        }
        if (moduleInfo == null || !moduleInfo.isValid()) {
            if (multiStatusHolder != null) {
                multiStatusHolder.warn("Unable to translate path '" + path + "': does not represent a valid module path within the source.", log);
            }
            return this.applyFilteredContent(path, filters);
        }
        if (descriptor && !this.isExclusivelyOneLayoutM2(sourceRepoLayout, targetRepoLayout)) {
            result = ModuleInfoUtils.constructDescriptorPath(moduleInfo, targetRepoLayout, true);
            resultModuleInfo = ModuleInfoUtils.moduleInfoFromDescriptorPath(result, targetRepoLayout);
        } else {
            result = ModuleInfoUtils.constructArtifactPath(moduleInfo, targetRepoLayout, true);
            resultModuleInfo = ModuleInfoUtils.moduleInfoFromArtifactPath(result, targetRepoLayout);
        }
        if (!resultModuleInfo.isValid() && multiStatusHolder != null) {
            multiStatusHolder.warn("Translated path '" + path + "', but the result does not represent a valid module path within the target.", log);
        }
        return this.applyFilteredContent(result, filters);
    }

    private String filterPaths(String path, LinkedList<Pair<String, TranslatorFilter>> filterList) {
        for (TranslatorFilter translatorFilter : this.translatorFilters) {
            if (!translatorFilter.filterRequired(path)) continue;
            String filteredContent = translatorFilter.getFilteredContent(path);
            path = translatorFilter.stripPath(path);
            filterList.add((Pair<String, TranslatorFilter>)new Pair((Object)filteredContent, (Object)translatorFilter));
        }
        return path;
    }

    private boolean isExclusivelyOneLayoutM2(RepoLayout layoutA, RepoLayout layoutB) {
        boolean sourceIsDefaultM2 = RepoLayoutUtils.isDefaultM2((RepoLayout)layoutA);
        boolean targetIsDefaultM2 = RepoLayoutUtils.isDefaultM2((RepoLayout)layoutB);
        return sourceIsDefaultM2 && !targetIsDefaultM2 || !sourceIsDefaultM2 && targetIsDefaultM2;
    }

    private String applyFilteredContent(String strippedPath, LinkedList<Pair<String, TranslatorFilter>> filterList) {
        while (filterList.size() != 0) {
            Pair<String, TranslatorFilter> filterPair = filterList.removeLast();
            strippedPath = ((TranslatorFilter)filterPair.getSecond()).applyFilteredContent(strippedPath, (String)filterPair.getFirst());
        }
        return strippedPath;
    }
}

