/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.liferay.portal.servlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.User;
import com.liferay.portal.service.CompanyLocalService;
import com.liferay.portal.service.GroupLocalService;
import com.liferay.portal.service.LayoutLocalService;
import com.liferay.portal.service.PortletPreferencesLocalService;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalService;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletPreferences;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortalURLServlet
extends HttpServlet {
    private static final Logger _logger = Logger.getLogger(PortalURLServlet.class.getName());
    private final transient CompanyLocalService _companyLocalService;
    private final transient GroupLocalService _groupLocalService;
    private final transient LayoutLocalService _layoutLocalService;
    private List<Layout> _layouts;
    private final transient PortletPreferencesLocalService _portletPreferencesLocalService;
    private final transient UserLocalService _userLocalService;

    public PortalURLServlet(CompanyLocalService companyLocalService, GroupLocalService groupLocalService, LayoutLocalService layoutLocalService, PortletPreferencesLocalService porletPreferencesLocalService, UserLocalService userLocalService) {
        this._companyLocalService = companyLocalService;
        this._groupLocalService = groupLocalService;
        this._layoutLocalService = layoutLocalService;
        this._portletPreferencesLocalService = porletPreferencesLocalService;
        this._userLocalService = userLocalService;
    }

    public void destroy() {
        if (this._layouts != null) {
            for (Layout layout : this._layouts) {
                try {
                    this._layoutLocalService.deleteLayout(layout.getPlid(), new ServiceContext());
                }
                catch (PortalException e) {
                    _logger.log(Level.WARNING, "Error trying to delete layout " + layout.getPlid(), e);
                }
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String portletId = request.getParameter("portlet-id");
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<h1> Portlet ID: " + portletId + "</h1>");
        Company company = (Company)this._companyLocalService.getCompanies().get(0);
        Group guestGroup = null;
        if (this._layouts == null) {
            this._layouts = new ArrayList<Layout>();
        }
        try {
            guestGroup = this._groupLocalService.getGroup(company.getCompanyId(), "Guest");
            User defaultUser = this._userLocalService.getDefaultUser(company.getCompanyId());
            UUID uuid = UUID.randomUUID();
            Layout layout = this._layoutLocalService.addLayout(defaultUser.getUserId(), guestGroup.getGroupId(), false, 0L, uuid.toString(), null, null, "portlet", false, "/" + uuid.toString(), new ServiceContext());
            this._layouts.add(layout);
            LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            layoutTypePortlet.setLayoutTemplateId(defaultUser.getUserId(), "1_column");
            String portletIdAdded = layoutTypePortlet.addPortletId(defaultUser.getUserId(), portletId, false);
            long ownerId = 0L;
            int ownerType = 3;
            PortletPreferences prefs = this._portletPreferencesLocalService.getPreferences(company.getCompanyId(), ownerId, ownerType, layout.getPlid(), portletIdAdded);
            this._portletPreferencesLocalService.updatePreferences(ownerId, ownerType, layout.getPlid(), portletIdAdded, prefs);
            this._layoutLocalService.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), layout.getTypeSettings());
            response.sendRedirect("/" + uuid.toString());
        }
        catch (PortalException e) {
            _logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void init() throws ServletException {
    }
}

