/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.liferay.portal.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import org.arquillian.liferay.portal.annotation.PortalURL;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestEnricher;

public class PortalURLTestEnricher
implements TestEnricher {
    @Inject
    private Instance<ProtocolMetaData> protocolMetadata;

    public boolean contains(Annotation[] annotations, Class<?> annotationClass) {
        for (Annotation current : annotations) {
            if (!annotationClass.isAssignableFrom(current.annotationType())) continue;
            return true;
        }
        return false;
    }

    public void enrich(Object testCase) {
        Field[] declaredFields;
        Class<?> testClass = testCase.getClass();
        for (Field declaredField : declaredFields = testClass.getDeclaredFields()) {
            if (!declaredField.isAnnotationPresent(PortalURL.class)) continue;
            PortalURL annotation = declaredField.getAnnotation(PortalURL.class);
            try {
                this.injectField(declaredField, testCase, annotation.value());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Exception when injecting the field", e);
            }
        }
    }

    public Annotation getAnnotation(Annotation[] annotations, Class<?> annotationClass) {
        for (Annotation current : annotations) {
            if (!annotationClass.isAssignableFrom(current.annotationType())) continue;
            return current;
        }
        return null;
    }

    public Object[] resolve(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parametersAnnotations = method.getParameterAnnotations();
        Object[] parameters = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Annotation[] parameterAnnotations = parametersAnnotations[i];
            if (!this.contains(parameterAnnotations, PortalURL.class)) continue;
            PortalURL annotation = (PortalURL)this.getAnnotation(parameterAnnotations, PortalURL.class);
            parameters[i] = this.resolve(annotation.value());
        }
        return parameters;
    }

    private void injectField(Field declaredField, Object testCase, String portletId) throws IllegalAccessException {
        this.setField(declaredField, testCase, this.resolve(portletId));
    }

    private URL resolve(String portletId) {
        ProtocolMetaData metaData = (ProtocolMetaData)this.protocolMetadata.get();
        if (metaData == null) {
            return null;
        }
        if (metaData.hasContext(HTTPContext.class)) {
            HTTPContext context = (HTTPContext)metaData.getContexts(HTTPContext.class).iterator().next();
            try {
                URL url = new URI("http", null, context.getHost(), context.getPort(), null, null, null).toURL();
                return new URL(url, "/o/install-portlet-servlet?portlet-id=" + portletId);
            }
            catch (Exception e) {
                throw new RuntimeException("Can't obtain URL, " + context, e);
            }
        }
        return null;
    }

    private void setField(Field declaredField, Object testCase, URL service) throws IllegalAccessException {
        boolean accessible = declaredField.isAccessible();
        declaredField.setAccessible(true);
        declaredField.set(testCase, service);
        declaredField.setAccessible(accessible);
    }
}

