/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.model;

import io.fabric8.kubernetes.api.model.v2_2.Container;
import io.fabric8.kubernetes.api.model.v2_2.Pod;
import io.fabric8.openshift.api.model.v2_2.DeploymentConfig;
import java.util.ArrayList;
import java.util.List;

public interface Template<T> {
    public T getTarget();

    public List<TemplateImageRef> getRefs();

    public void resolve(TemplateImageRef var1, String var2);

    public static class TemplateImageRef {
        private String path;
        private String containerName;

        public TemplateImageRef(String path, String containerName) {
            this.path = path;
            this.containerName = containerName;
        }

        public String getContainerName() {
            return this.containerName;
        }

        public String getPath() {
            return this.path;
        }
    }

    public static class PodTemplate
    extends ContainerTemplate<Pod> {
        private Pod pod;

        public PodTemplate(Pod pod) {
            this.pod = pod;
        }

        @Override
        public Pod getTarget() {
            return this.pod;
        }

        @Override
        protected List<Container> getContainers() {
            return this.pod.getSpec().getContainers();
        }
    }

    public static class DeploymentConfigTemplate
    extends ContainerTemplate<DeploymentConfig> {
        private DeploymentConfig config;

        public DeploymentConfigTemplate(DeploymentConfig config) {
            this.config = config;
        }

        @Override
        public DeploymentConfig getTarget() {
            return this.config;
        }

        @Override
        protected List<Container> getContainers() {
            return this.config.getSpec().getTemplate().getSpec().getContainers();
        }
    }

    public static abstract class ContainerTemplate<T>
    implements Template<T> {
        protected abstract List<Container> getContainers();

        @Override
        public List<TemplateImageRef> getRefs() {
            ArrayList<TemplateImageRef> refs = new ArrayList<TemplateImageRef>();
            for (Container container : this.getContainers()) {
                String image = container.getImage();
                if (image == null || !image.startsWith("arquillian:")) continue;
                refs.add(new TemplateImageRef(image.replaceFirst("arquillian\\:", ""), container.getName()));
            }
            return refs;
        }

        @Override
        public void resolve(TemplateImageRef ref, String imageRef) {
            for (Container container : this.getContainers()) {
                if (!container.getName().equals(ref.getContainerName())) continue;
                container.setImage(imageRef);
            }
        }
    }
}

