/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.install;

import io.fabric8.kubernetes.api.builder.v2_2.Visitor;
import io.fabric8.kubernetes.api.model.v2_2.HasMetadata;
import io.fabric8.kubernetes.api.model.v2_2.KubernetesList;
import io.fabric8.kubernetes.api.model.v2_2.KubernetesResourceList;
import io.fabric8.kubernetes.clnt.v2_2.KubernetesClient;
import io.fabric8.kubernetes.clnt.v2_2.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v2_2.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.openshift.clnt.v2_2.OpenShiftClient;
import io.fabric8.openshift.clnt.v2_2.ParameterValue;
import io.fabric8.openshift.clnt.v2_2.dsl.TemplateResource;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.arquillian.cube.impl.util.SystemEnvironmentVariables;
import org.arquillian.cube.kubernetes.impl.install.DefaultResourceInstaller;
import org.arquillian.cube.kubernetes.impl.visitor.CompositeVisitor;
import org.jboss.arquillian.core.spi.ServiceLoader;

public class OpenshiftResourceInstaller
extends DefaultResourceInstaller {
    private static final String PARAMETERS_FILE = "template.parameters.file";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<HasMetadata> install(URL url) {
        ServiceLoader serviceLoader = (ServiceLoader)this.serviceLoader.get();
        KubernetesClient client = (KubernetesClient)this.client.get();
        ArrayList visitors = new ArrayList(serviceLoader.all(Visitor.class));
        CompositeVisitor compositeVisitor = new CompositeVisitor(visitors);
        if (!client.isAdaptable(OpenShiftClient.class).booleanValue()) {
            return super.install(url);
        }
        OpenShiftClient openShiftClient = (OpenShiftClient)client.adapt(OpenShiftClient.class);
        try (InputStream is = url.openStream();){
            String templateParametersFile = SystemEnvironmentVariables.getPropertyOrEnvironmentVariable((String)PARAMETERS_FILE);
            KubernetesList list = templateParametersFile != null && new File(templateParametersFile).exists() ? (KubernetesList)((TemplateResource)openShiftClient.templates().load(is)).processLocally(new File(templateParametersFile)) : (KubernetesList)((TemplateResource)openShiftClient.templates().load(is)).processLocally(new ParameterValue[0]);
            List list2 = (List)((ListVisitFromServerGetDeleteRecreateWaitApplicable)openShiftClient.resourceList((KubernetesResourceList)list).accept((Visitor)compositeVisitor)).createOrReplace();
            return list2;
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((Throwable)t);
        }
    }
}

