/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.client;

import io.fabric8.kubernetes.clnt.v2_2.Config;
import io.fabric8.kubernetes.clnt.v2_2.ConfigBuilder;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.arquillian.cube.impl.util.ConfigUtil;
import org.arquillian.cube.impl.util.Strings;
import org.arquillian.cube.kubernetes.impl.DefaultConfiguration;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfigurationBuilder;

public class CubeOpenShiftConfiguration
extends DefaultConfiguration {
    private static final Config FALLBACK_CONFIG = new ConfigBuilder().build();
    private static final String ORIGIN_SERVER = "originServer";
    private static final String KEEP_ALIVE_GIT_SERVER = "keepAliveGitServer";
    private static final String DEFINITIONS_FILE = "definitionsFile";
    private static final String DEFINITIONS = "definitions";
    private static final String AUTO_START_CONTAINERS = "autoStartContainers";
    private static final String PROXIED_CONTAINER_PORTS = "proxiedContainerPorts";
    private static final String PORT_FORWARDER_BIND_ADDRESS = "portForwardBindAddress";
    private static final String DEFAULT_OPENSHIFT_CONFIG_FILE_NAME = "openshift.json";
    private final boolean keepAliveGitServer;
    private final String definitions;
    private final String definitionsFile;
    private final String[] autoStartContainers;
    private final Set<String> proxiedContainerPorts;
    private final String portForwardBindAddress;

    public CubeOpenShiftConfiguration(String sessionId, URL masterUrl, String namespace, URL environmentSetupScriptUrl, URL environmentTeardownScriptUrl, URL environmentConfigUrl, List<URL> environmentConfigAdditionalUrls, List<URL> environmentDependencies, boolean namespaceLazyCreateEnabled, boolean namespaceCleanupEnabled, long namespaceCleanupTimeout, boolean namespaceCleanupConfirmationEnabled, boolean namespaceDestroyEnabled, long namespaceDestroyTimeout, boolean namespaceDestroyConfirmationEnabled, long waitTimeout, long waitPollInterval, List<String> waitForServiceList, boolean ansiLoggerEnabled, boolean environmentInitEnabled, String kubernetesDomain, String dockerRegistry, boolean keepAliveGitServer, String definitions, String definitionsFile, String[] autoStartContainers, Set<String> proxiedContainerPorts, String portForwardBindAddress) {
        super(sessionId, masterUrl, namespace, environmentSetupScriptUrl, environmentTeardownScriptUrl, environmentConfigUrl, environmentConfigAdditionalUrls, environmentDependencies, namespaceLazyCreateEnabled, namespaceCleanupEnabled, namespaceCleanupTimeout, namespaceCleanupConfirmationEnabled, namespaceDestroyEnabled, namespaceDestroyConfirmationEnabled, namespaceDestroyTimeout, waitTimeout, waitPollInterval, waitForServiceList, ansiLoggerEnabled, environmentInitEnabled, kubernetesDomain, dockerRegistry);
        this.keepAliveGitServer = keepAliveGitServer;
        this.definitions = definitions;
        this.definitionsFile = definitionsFile;
        this.autoStartContainers = autoStartContainers;
        this.proxiedContainerPorts = proxiedContainerPorts;
        this.portForwardBindAddress = portForwardBindAddress;
    }

    private static String[] split(String str, String regex) {
        if (str == null || str.isEmpty()) {
            return new String[0];
        }
        return str.split(regex);
    }

    public static CubeOpenShiftConfiguration fromMap(Map<String, String> map) {
        File[] files;
        String sessionId = UUID.randomUUID().toString();
        String namespace = ConfigUtil.getBooleanProperty((String)"namespace.use.current", map, (Boolean)false) != false ? new ConfigBuilder().build().getNamespace() : ConfigUtil.getStringProperty((String)"namespace.use.existing", map, null);
        Boolean shouldCleanupNamespace = true;
        Boolean shouldDestroyNamespace = false;
        if (Strings.isNullOrEmpty((String)namespace)) {
            namespace = ConfigUtil.getStringProperty((String)"namespace.prefix", map, (String)"itest") + "-" + sessionId;
            shouldDestroyNamespace = true;
            shouldCleanupNamespace = false;
        }
        LinkedList<URL> additionalUrls = new LinkedList<URL>();
        File targetDir = new File(System.getProperty("basedir", ".") + "/target");
        if (targetDir.exists() && targetDir.isDirectory() && (files = targetDir.listFiles()) != null) {
            for (File file : files) {
                if (!file.getName().endsWith("-is.yml")) continue;
                try {
                    additionalUrls.add(file.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        try {
            return ((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)new CubeOpenShiftConfigurationBuilder().withSessionId(sessionId)).withNamespace(namespace)).withMasterUrl(new URL(ConfigUtil.getStringProperty((String)"master.url", (String)"kubernetes.master", map, (String)FALLBACK_CLIENT_CONFIG.getMasterUrl())))).withEnvironmentInitEnabled(ConfigUtil.getBooleanProperty((String)"env.init.enabled", map, (Boolean)true))).withEnvironmentSetupScriptUrl(CubeOpenShiftConfiguration.asUrlOrResource((String)ConfigUtil.getStringProperty((String)"env.setup.script.url", map, null)))).withEnvironmentTeardownScriptUrl(CubeOpenShiftConfiguration.asUrlOrResource((String)ConfigUtil.getStringProperty((String)"env.teardown.script.url", map, null)))).withEnvironmentConfigUrl(CubeOpenShiftConfiguration.getKubernetesConfigurationUrl(map, (String)DEFAULT_OPENSHIFT_CONFIG_FILE_NAME))).withEnvironmentConfigAdditionalUrls(additionalUrls)).withEnvironmentDependencies(ConfigUtil.asURL((List)Strings.splitAndTrimAsList((String)ConfigUtil.getStringProperty((String)"env.dependencies", map, (String)""), (String)"\\s+")))).withNamespaceLazyCreateEnabled(ConfigUtil.getBooleanProperty((String)"namespace.lazy.enabled", map, (Boolean)DEFAULT_NAMESPACE_LAZY_CREATE_ENABLED))).withNamespaceCleanupEnabled(ConfigUtil.getBooleanProperty((String)"namespace.cleanup.enabled", map, (Boolean)shouldCleanupNamespace))).withNamespaceCleanupConfirmationEnabled(ConfigUtil.getBooleanProperty((String)"namespace.cleanup.confirm.enabled", map, (Boolean)false))).withNamespaceCleanupTimeout(ConfigUtil.getLongProperty((String)"namespace.cleanup.timeout", map, (Long)DEFAULT_NAMESPACE_CLEANUP_TIMEOUT))).withNamespaceDestroyEnabled(ConfigUtil.getBooleanProperty((String)"namespace.destroy.enabled", map, (Boolean)shouldDestroyNamespace))).withNamespaceDestroyConfirmationEnabled(ConfigUtil.getBooleanProperty((String)"namespace.destroy.confirm.enabled", map, (Boolean)false))).withNamespaceDestroyTimeout(ConfigUtil.getLongProperty((String)"namespace.destroy.timeout", map, (Long)DEFAULT_NAMESPACE_DESTROY_TIMEOUT))).withWaitTimeout(ConfigUtil.getLongProperty((String)"wait.timeout", map, (Long)DEFAULT_WAIT_TIMEOUT))).withWaitPollInterval(ConfigUtil.getLongProperty((String)"wait.poll.interval", map, (Long)DEFAULT_WAIT_POLL_INTERVAL))).withWaitForServiceList(Strings.splitAndTrimAsList((String)ConfigUtil.getStringProperty((String)"wait.for.service.list", map, (String)""), (String)"\\s+"))).withAnsiLoggerEnabled(ConfigUtil.getBooleanProperty((String)"ansi.logger.enabled", map, (Boolean)true))).withKubernetesDomain(ConfigUtil.getStringProperty((String)"domain", (String)"kubernetes.domain", map, null))).withDockerRegistry(CubeOpenShiftConfiguration.getDockerRegistry(map))).withKeepAliveGitServer(ConfigUtil.getBooleanProperty((String)KEEP_ALIVE_GIT_SERVER, map, (Boolean)false))).withDefinitions(ConfigUtil.getStringProperty((String)DEFINITIONS, map, null))).withDefinitionsFile(ConfigUtil.getStringProperty((String)DEFINITIONS_FILE, map, null))).withAutoStartContainers(CubeOpenShiftConfiguration.split(ConfigUtil.getStringProperty((String)AUTO_START_CONTAINERS, map, (String)""), ","))).withProxiedContainerPorts(CubeOpenShiftConfiguration.split(ConfigUtil.getStringProperty((String)PROXIED_CONTAINER_PORTS, map, (String)""), ","))).withPortForwardBindAddress(ConfigUtil.getStringProperty((String)PORT_FORWARDER_BIND_ADDRESS, map, (String)"127.0.0.1"))).build();
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public String getOriginServer() {
        return this.getMasterUrl().toString();
    }

    public boolean isKeepAliveGitServer() {
        return this.keepAliveGitServer;
    }

    public String getDefinitionsFile() {
        return this.definitionsFile;
    }

    public String getDefinitions() {
        return this.definitions;
    }

    public boolean shouldKeepAliveGitServer() {
        return this.keepAliveGitServer;
    }

    public String[] getAutoStartContainers() {
        if (this.autoStartContainers == null) {
            return new String[0];
        }
        return this.autoStartContainers;
    }

    public Set<String> getProxiedContainerPorts() {
        if (this.proxiedContainerPorts == null) {
            return Collections.emptySet();
        }
        return this.proxiedContainerPorts;
    }

    public String getPortForwardBindAddress() {
        return this.portForwardBindAddress;
    }
}

