/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.utils;

import java.net.URL;
import java.util.logging.Logger;
import org.arquillian.cube.openshift.impl.proxy.Proxy;
import org.arquillian.cube.openshift.impl.utils.URLChecker;

public class K8sURLChecker
implements URLChecker {
    private static final Logger log = Logger.getLogger(K8sURLChecker.class.getName());
    private Proxy proxy;

    public K8sURLChecker(Proxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public boolean check(URL url) {
        try {
            int statusCode = this.proxy.status(url.toExternalForm());
            log.info(String.format("URL [%s] returned status code %s", url, statusCode));
            return K8sURLChecker.inRange(statusCode, 200, 299);
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static boolean inRange(int code, int min, int max) {
        return code >= min && code <= max;
    }
}

