/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.resources;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.arquillian.cube.kubernetes.impl.resolver.ResourceResolver;
import org.arquillian.cube.openshift.api.AddRoleToServiceAccount;
import org.arquillian.cube.openshift.api.OpenShiftResource;
import org.arquillian.cube.openshift.api.RoleBinding;
import org.arquillian.cube.openshift.api.Template;
import org.arquillian.cube.openshift.api.Templates;
import org.arquillian.cube.openshift.impl.adapter.OpenShiftAdapter;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.openshift.impl.utils.StringResolver;
import org.arquillian.cube.openshift.impl.utils.Strings;
import org.arquillian.cube.openshift.impl.utils.TemplateUtils;
import org.jboss.arquillian.test.spi.TestClass;

public class OpenShiftResourceFactory {
    private static final Logger log = Logger.getLogger(OpenShiftResourceFactory.class.getName());
    public static final String CLASSPATH_PREFIX = "classpath:";
    public static final String ARCHIVE_PREFIX = "archive:";
    public static final String URL_PREFIX = "http";
    private static final OSRFinder OSR_FINDER = new OSRFinder();
    private static final RBFinder RB_FINDER = new RBFinder();
    private static final ARSAFinder ARSA_FINDER = new ARSAFinder();
    private static final TEMPFinder TEMP_FINDER = new TEMPFinder();

    public static void createResources(String resourcesKey, OpenShiftAdapter adapter, Class<?> testClass, Properties properties) {
        try {
            StringResolver resolver = Strings.createStringResolver(properties);
            ArrayList<OpenShiftResource> openShiftResources = new ArrayList<OpenShiftResource>();
            OSR_FINDER.findAnnotations(openShiftResources, testClass);
            OpenShiftResourceFactory.createOpenShiftResources(resourcesKey, adapter, testClass, resolver, openShiftResources);
            ArrayList<RoleBinding> roleBindings = new ArrayList<RoleBinding>();
            RB_FINDER.findAnnotations(roleBindings, testClass);
            OpenShiftResourceFactory.createRoleBindings(resourcesKey, adapter, resolver, roleBindings);
            ArrayList<AddRoleToServiceAccount> arsaBindings = new ArrayList<AddRoleToServiceAccount>();
            ARSA_FINDER.findAnnotations(arsaBindings, testClass);
            OpenShiftResourceFactory.createRolesToServiceAccounts(resourcesKey, adapter, resolver, arsaBindings);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static void createResources(Class<?> testClass, OpenShiftAdapter client, Method testMethod, Properties properties) {
        StringResolver resolver = Strings.createStringResolver(properties);
        List<Annotation> openShiftResources = Arrays.asList(testMethod.getAnnotationsByType(OpenShiftResource.class));
        try {
            OpenShiftResourceFactory.createOpenShiftResources(OpenShiftResourceFactory.createResourceKey(testClass, testMethod), client, testClass, resolver, openShiftResources);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static void createRolesToServiceAccounts(String resourcesKey, OpenShiftAdapter adapter, StringResolver resolver, List<AddRoleToServiceAccount> arsaBindings) {
        for (AddRoleToServiceAccount arsa : arsaBindings) {
            String role = resolver.resolve(arsa.role());
            String saPattern = String.format("system:serviceaccount:${kubernetes.namespace}:%s", arsa.serviceAccount());
            String serviceAccount = resolver.resolve(saPattern);
            log.info(String.format("Adding role %s to service account %s", role, serviceAccount));
            adapter.addRoleBinding(resourcesKey, role, serviceAccount);
        }
    }

    private static void createRoleBindings(String resourcesKey, OpenShiftAdapter adapter, StringResolver resolver, List<RoleBinding> roleBindings) {
        for (RoleBinding rb : roleBindings) {
            String roleRefName = resolver.resolve(rb.roleRefName());
            String userName = resolver.resolve(rb.userName());
            log.info(String.format("Adding new role binding: %s / %s", roleRefName, userName));
            adapter.addRoleBinding(resourcesKey, roleRefName, userName);
        }
    }

    private static void createOpenShiftResources(String resourcesKey, OpenShiftAdapter adapter, Class<?> testClass, StringResolver resolver, List<OpenShiftResource> openShiftResources) throws IOException {
        for (OpenShiftResource osr : openShiftResources) {
            String file = resolver.resolve(osr.value());
            InputStream stream = ResourceResolver.resolve((String)file).openStream();
            log.info(String.format("Creating new OpenShift resource: %s", file));
            adapter.createResource(resourcesKey, stream);
        }
    }

    static <T> List<Template> getTemplates(T objectType) {
        try {
            ArrayList<Template> templates = new ArrayList<Template>();
            TEMP_FINDER.findAnnotations(templates, objectType);
            return templates;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    static <T> boolean syncInstantiation(T objectType) {
        ArrayList templates = new ArrayList();
        Templates tr = (Templates)TEMP_FINDER.findAnnotations(templates, objectType);
        if (tr == null) {
            return true;
        }
        return tr.syncInstantiation();
    }

    private static void deleteResources(String resourcesKey, OpenShiftAdapter adapter) {
        try {
            adapter.deleteResources(resourcesKey);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static void deleteTemplates(String templateKeyPrefix, List<Template> templates, OpenShiftAdapter openshiftAdapter, CubeOpenShiftConfiguration configuration) throws Exception {
        for (Template template : templates) {
            StringResolver resolver = Strings.createStringResolver(configuration.getProperties());
            String templateURL = TemplateUtils.readTemplateUrl(template, configuration, false, resolver);
            openshiftAdapter.deleteTemplate(templateKeyPrefix + templateURL);
        }
    }

    public static void deleteResources(Class<?> testClass, Method testMethod, OpenShiftAdapter client) {
        try {
            client.deleteResources(OpenShiftResourceFactory.createResourceKey(testClass, testMethod));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static void deleteEnvironment(TestClass testClass, OpenShiftAdapter client, CubeOpenShiftConfiguration configuration, List<Template> templates) throws Exception {
        if (configuration.getCubeConfiguration().isNamespaceCleanupEnabled()) {
            Class javaClass = testClass.getJavaClass();
            log.info(String.format("Deleting environment for %s", testClass.getName()));
            OpenShiftResourceFactory.deleteTemplates(testClass.getName(), templates, client, configuration);
            OpenShiftResourceFactory.deleteResources(testClass.getName(), client);
            OpenShiftResourceFactory.additionalCleanup(client, Collections.singletonMap("test-case", javaClass.getSimpleName().toLowerCase()));
        } else {
            log.info(String.format("Ignoring cleanup for %s", testClass.getName()));
        }
    }

    static void additionalCleanup(OpenShiftAdapter client, Map<String, String> labels) throws Exception {
        client.cleanRemnants(labels);
    }

    public static String createResourceKey(Class<?> testClass, Method testMethod) {
        return testClass.getName() + "_" + testMethod.getName();
    }

    private static class TEMPFinder
    extends Finder<Templates, Template> {
        private TEMPFinder() {
        }

        @Override
        protected Class<Templates> getWrapperType() {
            return Templates.class;
        }

        @Override
        protected Class<Template> getSingleType() {
            return Template.class;
        }

        protected Template[] toSingles(Templates templates) {
            return templates.templates();
        }

        protected boolean syncInstantiation(Templates templates) {
            return templates.syncInstantiation();
        }
    }

    private static class ARSAFinder
    extends Finder<AddRoleToServiceAccount.List, AddRoleToServiceAccount> {
        private ARSAFinder() {
        }

        @Override
        protected Class<AddRoleToServiceAccount.List> getWrapperType() {
            return AddRoleToServiceAccount.List.class;
        }

        @Override
        protected Class<AddRoleToServiceAccount> getSingleType() {
            return AddRoleToServiceAccount.class;
        }

        protected AddRoleToServiceAccount[] toSingles(AddRoleToServiceAccount.List roleBindings) {
            return roleBindings.value();
        }
    }

    private static class RBFinder
    extends Finder<RoleBinding.List, RoleBinding> {
        private RBFinder() {
        }

        @Override
        protected Class<RoleBinding.List> getWrapperType() {
            return RoleBinding.List.class;
        }

        @Override
        protected Class<RoleBinding> getSingleType() {
            return RoleBinding.class;
        }

        protected RoleBinding[] toSingles(RoleBinding.List roleBindings) {
            return roleBindings.value();
        }
    }

    private static class OSRFinder
    extends Finder<OpenShiftResource.List, OpenShiftResource> {
        private OSRFinder() {
        }

        @Override
        protected Class<OpenShiftResource.List> getWrapperType() {
            return OpenShiftResource.List.class;
        }

        @Override
        protected Class<OpenShiftResource> getSingleType() {
            return OpenShiftResource.class;
        }

        protected OpenShiftResource[] toSingles(OpenShiftResource.List openShiftResources) {
            return openShiftResources.value();
        }
    }

    private static abstract class Finder<U extends Annotation, V extends Annotation> {
        private Finder() {
        }

        protected abstract Class<U> getWrapperType();

        protected abstract Class<V> getSingleType();

        protected abstract V[] toSingles(U var1);

        <T> U findAnnotations(List<V> annotations, T type) {
            if (type == Object.class) {
                return null;
            }
            if (type instanceof Class) {
                Class testClass = (Class)type;
                U anns = testClass.getAnnotation(this.getWrapperType());
                this.addAnnotationsFromWrapper(anns, annotations);
                V ann = testClass.getAnnotation(this.getSingleType());
                if (ann != null) {
                    annotations.add(0, ann);
                }
                this.findAnnotations(annotations, testClass.getSuperclass());
                return anns;
            }
            if (type instanceof Method) {
                Method testMethod = (Method)type;
                U anns = testMethod.getAnnotation(this.getWrapperType());
                this.addAnnotationsFromWrapper(anns, annotations);
                V ann = testMethod.getAnnotation(this.getSingleType());
                if (ann != null) {
                    annotations.add(0, ann);
                }
                return anns;
            }
            return null;
        }

        void addAnnotationsFromWrapper(U anns, List<V> annotations) {
            if (anns != null) {
                Annotation[] ann = this.toSingles((Annotation)anns);
                for (int i = ann.length - 1; i >= 0; --i) {
                    annotations.add(0, ann[i]);
                }
            }
        }
    }
}

