/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.client;

import io.fabric8.kubernetes.api.model.v3_1.ContainerFluent;
import io.fabric8.kubernetes.api.model.v3_1.Pod;
import io.fabric8.kubernetes.api.model.v3_1.PodBuilder;
import io.fabric8.kubernetes.api.model.v3_1.PodFluent;
import io.fabric8.kubernetes.api.model.v3_1.PodSpecFluent;
import io.fabric8.kubernetes.api.model.v3_1.Service;
import io.fabric8.kubernetes.api.model.v3_1.ServiceBuilder;
import io.fabric8.kubernetes.api.model.v3_1.ServiceFluent;
import io.fabric8.kubernetes.api.model.v3_1.ServiceSpecFluent;
import io.fabric8.kubernetes.api.model.v3_1.VolumeFluent;
import io.fabric8.kubernetes.clnt.v3_1.Config;
import io.fabric8.kubernetes.clnt.v3_1.KubernetesClient;
import io.fabric8.kubernetes.clnt.v3_1.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v3_1.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v3_1.dsl.Resource;
import io.fabric8.openshift.clnt.v3_1.OpenShiftClient;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.arquillian.cube.kubernetes.impl.portforward.PortForwarder;
import org.arquillian.cube.openshift.impl.client.ResourceUtil;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;

public class GitServer {
    private static final String GIT_SERVICE = "git";
    private static final String GIT_LOCALPORT = "10001";
    private static final String GIT_REMOTEPORT = "8080";
    private OpenShiftClient client;
    private String namespace;
    private Pod server;
    private PortForwarder forwarder;
    private Config config;
    private Service service;

    public GitServer(OpenShiftClient client, Config config, String namespace) {
        this.client = client;
        this.config = config;
        this.namespace = namespace;
    }

    public URI push(File source, String name) throws Exception {
        this.init();
        File gitRoot = new File("target", name);
        FileUtils.copyDirectory((File)source, (File)gitRoot);
        String repoUrl = String.format("http://localhost:%s/%s", GIT_LOCALPORT, name);
        Git git = Git.init().setDirectory(gitRoot).call();
        Repository repo = git.getRepository();
        repo.getConfig().setString("remote", "origin", "url", repoUrl);
        repo.getConfig().save();
        git.add().addFilepattern(".").call();
        git.commit().setMessage("testing").setAuthor("Arquillian", "cube@discuss.arquillian.org").call();
        git.push().setRemote("origin").setPushAll().setForce(true).call();
        repo.close();
        String serverUrl = String.format("http://%s:%s/%s", GIT_SERVICE, GIT_REMOTEPORT, name);
        return URI.create(serverUrl);
    }

    public void shutdown() throws Exception {
        if (this.forwarder != null) {
            this.forwarder.close();
        }
        if (this.service != null) {
            ((Resource)((NonNamespaceOperation)this.client.services().inNamespace(this.namespace)).withName(this.service.getMetadata().getName())).delete();
        }
        if (this.server != null) {
            ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.namespace)).withName(this.server.getMetadata().getName())).delete();
            ((Resource)((NonNamespaceOperation)this.client.secrets().inNamespace(this.namespace)).withName("gitserver-config")).delete();
        }
    }

    private void init() throws Exception {
        this.createService();
        if (this.server == null) {
            this.server = this.getSpec();
            this.server = (Pod)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.namespace)).withName(this.server.getMetadata().getName())).get();
            if (this.server == null) {
                this.server = (Pod)((NonNamespaceOperation)this.client.pods().inNamespace(this.namespace)).create((Object[])new Pod[]{this.getSpec()});
                this.server = ResourceUtil.waitForStart((KubernetesClient)this.client, this.server);
            }
        }
        if (this.forwarder != null) {
            this.forwarder.close();
        }
        this.forwarder = new PortForwarder(this.config, this.server.getMetadata().getName());
        this.forwarder.forwardPort(Integer.valueOf(GIT_LOCALPORT).intValue(), Integer.valueOf(GIT_REMOTEPORT).intValue());
    }

    private Pod getSpec() {
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("generatedby", "arquillian");
        labels.put("pod", "arquillian-gitserver");
        return ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.EmptyDirNested)((PodSpecFluent.VolumesNested)((PodFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("arquillian-gitserver")).withLabels(labels)).endMetadata()).withNewSpec().addNewContainer().withName("arquillian-gitserver")).withImage("aslakknutsen/openshift-arquillian-gitserver")).addNewPort().withContainerPort(Integer.valueOf(GIT_REMOTEPORT))).endPort()).addNewEnv().withName("GIT_HOME")).withValue("/var/lib/git")).endEnv()).addNewVolumeMount().withName("git-repo")).withMountPath("/var/lib/git")).withReadOnly(Boolean.valueOf(false))).endVolumeMount()).endContainer()).addNewVolume().withName("git-repo")).withNewEmptyDir().withMedium("Memory")).endEmptyDir()).endVolume()).endSpec()).build();
    }

    private void createService() {
        if (this.service != null) {
            return;
        }
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("generatedby", "arquillian");
        Service svc = (Service)((Resource)((NonNamespaceOperation)this.client.services().inNamespace(this.namespace)).withName(GIT_SERVICE)).get();
        if (svc == null) {
            svc = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(GIT_SERVICE)).withLabels(labels)).endMetadata()).withNewSpec().addNewPort().withPort(Integer.valueOf(GIT_REMOTEPORT))).withNewTargetPort(Integer.valueOf(GIT_REMOTEPORT))).endPort()).addToSelector("pod", "arquillian-gitserver")).and()).build();
            ((NonNamespaceOperation)this.client.services().inNamespace(this.namespace)).create((Object[])new Service[]{svc});
        }
        this.service = svc;
    }
}

