/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl.portforward;

import io.fabric8.kubernetes.clnt.v2_2.Config;
import io.fabric8.kubernetes.clnt.v2_2.internal.SSLUtils;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.UndertowClient;
import io.undertow.client.spdy.SpdyClientConnection;
import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.spdy.SpdyChannel;
import io.undertow.protocols.spdy.SpdyChannelWithoutFlowControl;
import io.undertow.server.XnioByteBufferPool;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.StringReadChannelListener;
import java.io.Closeable;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.arquillian.cube.kubernetes.impl.portforward.PortForwardOpenListener;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.ssl.XnioSsl;

public final class PortForwarder
implements Closeable {
    private static final String PORT_FWD = "%sapi/v1/namespaces/%s/pods/%s/portforward";
    private static final AtomicInteger requestId = new AtomicInteger();
    private final OptionMap DEFAULT_OPTIONS;
    private InetAddress portForwardBindAddress = Inet4Address.getLoopbackAddress();
    private URI portForwardURI;
    private Pool<ByteBuffer> bufferPoolSlice;
    private ByteBufferPool bufferPool;
    private XnioWorker xnioWorker;
    private ClientConnection connection;
    private Collection<PortForwardServer> servers = new ArrayList<PortForwardServer>();

    public PortForwarder(Config config, String podName) throws Exception {
        try {
            this.portForwardURI = URI.create(String.format(PORT_FWD, config.getMasterUrl(), config.getNamespace(), podName));
            Xnio xnio = Xnio.getInstance();
            this.DEFAULT_OPTIONS = OptionMap.builder().set(Options.WORKER_NAME, (Object)String.format("PortForwarding for %s/%s", config.getNamespace(), podName)).set(Options.WORKER_IO_THREADS, 16).set(Options.CONNECTION_HIGH_WATER, 400).set(Options.CONNECTION_LOW_WATER, 200).set(Options.WORKER_TASK_CORE_THREADS, 16).set(Options.WORKER_TASK_MAX_THREADS, 128).set(Options.TCP_NODELAY, true).set(Options.KEEP_ALIVE, true).set(Options.SSL_PROTOCOL, (Object)"TLS").getMap();
            XnioSsl xnioSsl = xnio.getSslProvider(SSLUtils.keyManagers((Config)config), new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String s) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String s) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, this.DEFAULT_OPTIONS);
            this.xnioWorker = xnio.createWorker(null, this.DEFAULT_OPTIONS);
            this.bufferPoolSlice = new ByteBufferSlicePool(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, 17408, 348160);
            this.bufferPool = new XnioByteBufferPool(this.bufferPoolSlice);
            IoFuture connectFuture = UndertowClient.getInstance().connect(this.portForwardURI, this.xnioWorker, xnioSsl, this.bufferPool, this.DEFAULT_OPTIONS);
            this.connection = (ClientConnection)connectFuture.getInterruptibly();
            ClientRequest request = new ClientRequest().setMethod(Methods.POST).setPath(this.portForwardURI.getPath());
            request.getRequestHeaders().put(Headers.HOST, this.portForwardURI.getHost()).put(Headers.CONNECTION, "Upgrade").put(Headers.UPGRADE, "SPDY/3.1");
            if (config.getOauthToken() != null) {
                request.getRequestHeaders().put(Headers.AUTHORIZATION, "Bearer " + config.getOauthToken());
            }
            final CountDownLatch latch = new CountDownLatch(1);
            final IOException[] holder = new IOException[1];
            this.connection.sendRequest(request, (ClientCallback)new ClientCallback<ClientExchange>(){

                public void completed(ClientExchange result) {
                    result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                        public void completed(ClientExchange result) {
                            try {
                                PortForwarder.this.upgradeConnection(result);
                            }
                            catch (Exception e) {
                                holder[0] = (IOException)new IOException("Unexpected error", e).fillInStackTrace();
                            }
                            finally {
                                latch.countDown();
                            }
                        }

                        public void failed(IOException e) {
                            holder[0] = e;
                            latch.countDown();
                        }
                    });
                }

                public void failed(IOException e) {
                    holder[0] = e;
                    latch.countDown();
                }
            });
            latch.await();
            if (holder[0] != null) {
                throw new IOException("Failed to establish portforward client connection", holder[0]);
            }
        }
        catch (Throwable t) {
            if (this.connection != null) {
                IoUtils.safeClose((Closeable)this.connection);
            }
            if (this.xnioWorker != null) {
                this.xnioWorker.shutdown();
            }
            throw t;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            System.out.println("Usage: portforward <namespace> <pod> <source-port> <target-port> -b [optional] <bindAddress>");
            System.out.println("Example: portforward mynamespace somepod 8080 8080 -b 10.1.1.1");
            System.exit(1);
        }
        String namespace = args[0];
        String podName = args[1];
        int sourcePort = Integer.valueOf(args[2]);
        int targetPort = Integer.valueOf(args[3]);
        InetAddress bindAddress = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].contains("-b")) continue;
            bindAddress = InetAddress.getByName(args[i + 1]);
        }
        Config config = new Config();
        config.setNamespace(namespace);
        PortForwarder forwarder = new PortForwarder(config, podName);
        forwarder.setPortForwardBindAddress(bindAddress);
        PortForwardServer server = forwarder.forwardPort(sourcePort, targetPort);
        System.in.read();
        server.close();
        forwarder.close();
    }

    public synchronized PortForwardServer forwardPort(int sourcePort, int targetPort) throws IllegalArgumentException, IOException {
        PortForwardServer server = new PortForwardServer(this.createServer(sourcePort, targetPort), targetPort);
        this.servers.add(server);
        return server;
    }

    @Override
    public synchronized void close() {
        for (PortForwardServer server : this.servers) {
            IoUtils.safeClose((Closeable)server.server);
        }
        this.servers.clear();
        IoUtils.safeClose((Closeable)this.connection);
        this.connection = null;
        this.xnioWorker.shutdown();
        this.xnioWorker = null;
    }

    public void setPortForwardBindAddress(InetAddress bindAddress) {
        if (bindAddress == null) {
            bindAddress = Inet4Address.getLoopbackAddress();
        }
        this.portForwardBindAddress = bindAddress;
    }

    private synchronized void close(PortForwardServer server) {
        IoUtils.safeClose((Closeable)server.server);
        this.servers.remove(server);
    }

    private AcceptingChannel<? extends StreamConnection> createServer(int sourcePort, int targetPort) throws IllegalArgumentException, IOException {
        OptionMap socketOptions = OptionMap.builder().set(Options.WORKER_IO_THREADS, 16).set(Options.TCP_NODELAY, true).set(Options.REUSE_ADDRESSES, true).getMap();
        ChannelListener acceptListener = ChannelListeners.openListenerAdapter((ChannelListener)new PortForwardOpenListener(this.connection, this.portForwardURI.getPath(), targetPort, requestId, this.bufferPoolSlice, OptionMap.EMPTY));
        AcceptingChannel server = this.xnioWorker.createStreamConnectionServer((SocketAddress)new InetSocketAddress(this.portForwardBindAddress, sourcePort), acceptListener, socketOptions);
        server.resumeAccepts();
        return server;
    }

    private void upgradeConnection(ClientExchange result) throws IOException {
        SpdyChannelWithoutFlowControl spdyChannel;
        if (result.getResponse().getResponseCode() == 101) {
            new StringReadChannelListener(this.bufferPool){

                protected void stringDone(String string) {
                }

                protected void error(IOException e) {
                }
            }.setup(result.getResponseChannel());
            XnioByteBufferPool heapBufferPool = new XnioByteBufferPool((Pool)new ByteBufferSlicePool(BufferAllocator.BYTE_BUFFER_ALLOCATOR, 8196, 8196));
            spdyChannel = new SpdyChannelWithoutFlowControl(this.connection.performUpgrade(), this.bufferPool, null, (ByteBufferPool)heapBufferPool, true, OptionMap.EMPTY);
            Integer idleTimeout = (Integer)this.DEFAULT_OPTIONS.get(UndertowOptions.IDLE_TIMEOUT);
            if (idleTimeout != null && idleTimeout > 0) {
                spdyChannel.setIdleTimeout(idleTimeout.intValue());
            }
        } else {
            throw new IOException("Failed to upgrade connection");
        }
        this.connection = new SpdyClientConnection((SpdyChannel)spdyChannel, null);
    }

    public final class PortForwardServer {
        private final AcceptingChannel<? extends StreamConnection> server;
        private final int targetPort;

        private PortForwardServer(AcceptingChannel<? extends StreamConnection> server, int targetPort) {
            this.server = server;
            this.targetPort = targetPort;
        }

        public int getSourcePort() {
            return this.getLocalAddress().getPort();
        }

        public int getTargetPort() {
            return this.targetPort;
        }

        public InetSocketAddress getLocalAddress() {
            return (InetSocketAddress)this.server.getLocalAddress(InetSocketAddress.class);
        }

        public void close() {
            PortForwarder.this.close(this);
        }
    }
}

