/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl.namespace;

import io.fabric8.kubernetes.api.model.v2_2.DoneableNamespace;
import io.fabric8.kubernetes.api.model.v2_2.Namespace;
import io.fabric8.kubernetes.api.model.v2_2.NamespaceFluent;
import io.fabric8.kubernetes.clnt.v2_2.KubernetesClient;
import io.fabric8.kubernetes.clnt.v2_2.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v2_2.dsl.Resource;
import java.util.Collections;
import java.util.Map;
import java.util.Scanner;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.api.LabelProvider;
import org.arquillian.cube.kubernetes.api.Logger;
import org.arquillian.cube.kubernetes.api.NamespaceService;
import org.arquillian.cube.kubernetes.api.WithToImmutable;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.Validate;

public class DefaultNamespaceService
implements NamespaceService {
    protected static final String PROJECT_LABEL = "project";
    protected static final String FRAMEWORK_LABEL = "framework";
    protected static final String COMPONENT_LABEL = "component";
    protected static final String ARQUILLIAN_FRAMEWORK = "arquillian";
    protected static final String ITEST_COMPONENT = "integrationTest";
    @Inject
    protected Instance<KubernetesClient> client;
    @Inject
    protected Instance<LabelProvider> labelProvider;
    @Inject
    protected Instance<Logger> logger;
    @Inject
    protected Instance<Configuration> configuration;
    protected NamespaceService delegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamespaceService toImmutable() {
        if (this.delegate != null) {
            return this.delegate;
        }
        DefaultNamespaceService defaultNamespaceService = this;
        synchronized (defaultNamespaceService) {
            if (this.delegate == null) {
                this.delegate = new ImmutableNamespaceService((KubernetesClient)this.client.get(), (Configuration)this.configuration.get(), (LabelProvider)((LabelProvider)this.labelProvider.get()).toImmutable(), (Logger)((Logger)this.logger.get()).toImmutable());
            }
        }
        return this.delegate;
    }

    @Override
    public Namespace create(String namespace) {
        return this.toImmutable().create(namespace);
    }

    @Override
    public Namespace create(String namespace, Map<String, String> annotations) {
        return this.toImmutable().create(namespace, annotations);
    }

    @Override
    public Namespace annotate(String namespace, Map<String, String> annotations) {
        return this.toImmutable().annotate(namespace, annotations);
    }

    @Override
    public Boolean delete(String namespace) {
        return this.toImmutable().delete(namespace);
    }

    @Override
    public Boolean exists(String namespace) {
        return this.toImmutable().exists(namespace);
    }

    @Override
    @Deprecated
    public void clean(String namespace) {
        this.toImmutable().clean(namespace);
    }

    @Override
    public void destroy(String namespace) {
        this.toImmutable().destroy(namespace);
    }

    public static class ImmutableNamespaceService
    implements NamespaceService,
    WithToImmutable<NamespaceService> {
        protected final KubernetesClient client;
        protected final LabelProvider labelProvider;
        protected final Logger logger;
        protected final Configuration configuration;

        public ImmutableNamespaceService(KubernetesClient client, Configuration configuration, LabelProvider labelProvider, Logger logger) {
            Validate.notNull((Object)client, (String)"A KubernetesClient instance is required.");
            Validate.notNull((Object)labelProvider, (String)"A LabelProvider  instance is required.");
            Validate.notNull((Object)logger, (String)"A Logger instance is required.");
            Validate.notNull((Object)configuration, (String)"Configuration is required.");
            this.client = client;
            this.configuration = configuration;
            this.labelProvider = labelProvider;
            this.logger = logger;
        }

        @Override
        public Namespace create(String namespace) {
            return this.create(namespace, Collections.emptyMap());
        }

        @Override
        public Namespace create(String namespace, Map<String, String> annotations) {
            this.logger.status("Creating namespace: " + namespace + "...");
            Namespace result = ((DoneableNamespace)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)((DoneableNamespace)this.client.namespaces().createNew()).withNewMetadata().withName(namespace)).withAnnotations(annotations)).addToLabels(this.labelProvider.getLabels())).addToLabels(DefaultNamespaceService.PROJECT_LABEL, this.client.getNamespace())).addToLabels(DefaultNamespaceService.FRAMEWORK_LABEL, DefaultNamespaceService.ARQUILLIAN_FRAMEWORK)).addToLabels(DefaultNamespaceService.COMPONENT_LABEL, DefaultNamespaceService.ITEST_COMPONENT)).endMetadata()).done();
            this.logger.info("To switch to the new namespace: kubectl config set-context `kubectl config current-context` --namespace=" + namespace);
            return result;
        }

        @Override
        public Namespace annotate(String namespace, Map<String, String> annotations) {
            return ((DoneableNamespace)((NamespaceFluent.MetadataNested)((DoneableNamespace)((Resource)this.client.namespaces().withName(namespace)).edit()).editMetadata().addToAnnotations(annotations)).endMetadata()).done();
        }

        @Override
        public Boolean delete(String namespace) {
            this.logger.info("Deleting namespace: " + namespace + "...");
            Boolean deleted = (Boolean)((Resource)this.client.namespaces().withName(namespace)).delete();
            if (deleted.booleanValue()) {
                this.logger.info("Namespace: " + namespace + ", successfully deleted");
            }
            return deleted;
        }

        @Override
        public Boolean exists(String namespace) {
            return ((Resource)this.client.namespaces().withName(namespace)).get() != null;
        }

        @Override
        @Deprecated
        public void clean(String namespace) {
            KubernetesClient client = this.client;
            ((NonNamespaceOperation)client.extensions().deployments().inNamespace(namespace)).delete();
            ((NonNamespaceOperation)client.extensions().replicaSets().inNamespace(namespace)).delete();
            ((NonNamespaceOperation)client.replicationControllers().inNamespace(namespace)).delete();
            ((NonNamespaceOperation)client.pods().inNamespace(namespace)).delete();
            ((NonNamespaceOperation)client.extensions().ingresses().inNamespace(namespace)).delete();
            ((NonNamespaceOperation)client.services().inNamespace(namespace)).delete();
            ((Resource)client.securityContextConstraints().withName(namespace)).delete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void destroy(String namespace) {
            Logger logger = this.logger;
            Configuration configuration = this.configuration;
            try {
                if (configuration.isNamespaceDestroyConfirmationEnabled()) {
                    this.showErrors();
                    logger.info("");
                    logger.info("Waiting to destroy the namespace.");
                    logger.info("Please press <enter> to cleanup the namespace.");
                    Scanner scanner = new Scanner(System.in);
                    scanner.nextLine();
                    logger.info("Cleaning up...");
                    return;
                }
                long timeout = configuration.getNamespaceDestroyTimeout();
                if (timeout > 0L) {
                    this.showErrors();
                    logger.info("");
                    logger.info("Waiting for " + timeout + " seconds before destroying the namespace");
                    try {
                        Thread.sleep(timeout * 1000L);
                    }
                    catch (InterruptedException e) {
                        logger.info("Interrupted waiting to GC the namespace: " + e);
                    }
                }
            }
            finally {
                this.delete(namespace);
            }
        }

        private void showErrors() {
        }

        @Override
        public NamespaceService toImmutable() {
            return this;
        }
    }
}

