/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl.install;

import io.fabric8.kubernetes.api.builder.v2_2.Visitor;
import io.fabric8.kubernetes.api.model.v2_2.HasMetadata;
import io.fabric8.kubernetes.clnt.v2_2.KubernetesClient;
import io.fabric8.kubernetes.clnt.v2_2.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v2_2.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.api.Logger;
import org.arquillian.cube.kubernetes.api.ResourceInstaller;
import org.arquillian.cube.kubernetes.api.WithToImmutable;
import org.arquillian.cube.kubernetes.impl.visitor.CompositeVisitor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;

public class DefaultResourceInstaller
implements ResourceInstaller {
    @Inject
    protected Instance<KubernetesClient> client;
    @Inject
    protected Instance<Configuration> configuration;
    @Inject
    protected Instance<Logger> logger;
    @Inject
    protected Instance<ServiceLoader> serviceLoader;
    protected ResourceInstaller delegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceInstaller toImmutable() {
        if (this.delegate != null) {
            return this.delegate;
        }
        DefaultResourceInstaller defaultResourceInstaller = this;
        synchronized (defaultResourceInstaller) {
            if (this.delegate == null) {
                this.delegate = new ImmutableResourceInstaller((KubernetesClient)this.client.get(), (Configuration)this.configuration.get(), (Logger)((Logger)this.logger.get()).toImmutable(), new ArrayList<Visitor>(((ServiceLoader)this.serviceLoader.get()).all(Visitor.class)));
            }
        }
        return this.delegate;
    }

    @Override
    public List<HasMetadata> install(URL url) {
        return this.toImmutable().install(url);
    }

    @Override
    public Map<HasMetadata, Boolean> uninstall(URL url) {
        return this.toImmutable().uninstall(url);
    }

    @Override
    public Map<HasMetadata, Boolean> uninstall(List<HasMetadata> list) {
        return this.toImmutable().uninstall(list);
    }

    public static class ImmutableResourceInstaller
    implements ResourceInstaller,
    WithToImmutable<ResourceInstaller> {
        private final KubernetesClient client;
        private final Configuration configuration;
        private final Logger logger;
        private final List<Visitor> visitors;

        public ImmutableResourceInstaller(KubernetesClient client, Configuration configuration, Logger logger, List<Visitor> visitors) {
            this.client = client;
            this.configuration = configuration;
            this.logger = logger;
            this.visitors = visitors;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<HasMetadata> install(URL url) {
            CompositeVisitor compositeVisitor = new CompositeVisitor(this.visitors);
            try (InputStream is = url.openStream();){
                List list = (List)((ListVisitFromServerGetDeleteRecreateWaitApplicable)this.client.load(is).accept(compositeVisitor)).createOrReplace();
                return list;
            }
            catch (Throwable t) {
                throw KubernetesClientException.launderThrowable((Throwable)t);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Map<HasMetadata, Boolean> uninstall(URL url) {
            HashMap result = new HashMap();
            CompositeVisitor compositeVisitor = new CompositeVisitor(this.visitors);
            try (InputStream is = url.openStream();){
                Map<HasMetadata, Boolean> map = this.uninstall((List)((ListVisitFromServerGetDeleteRecreateWaitApplicable)this.client.load(is).accept(compositeVisitor)).get());
                return map;
            }
            catch (Throwable t) {
                throw KubernetesClientException.launderThrowable((Throwable)t);
            }
        }

        @Override
        public Map<HasMetadata, Boolean> uninstall(List<HasMetadata> list) {
            HashMap<HasMetadata, Boolean> result = new HashMap<HasMetadata, Boolean>();
            this.preUninstallCheck();
            for (HasMetadata h : list) {
                try {
                    Boolean deleted = (Boolean)this.client.resource(h).delete();
                    result.put(h, deleted);
                }
                catch (Throwable t) {
                    result.put(h, false);
                }
            }
            return result;
        }

        public void preUninstallCheck() {
            if (this.configuration.isNamespaceCleanupConfirmationEnabled()) {
                this.logger.info("");
                this.logger.info("Waiting to cleanup the namespace.");
                this.logger.info("Please press <enter> to cleanup the namespace.");
                Scanner scanner = new Scanner(System.in);
                scanner.nextLine();
                this.logger.info("Cleaning up...");
                return;
            }
            long timeout = this.configuration.getNamespaceCleanupTimeout();
            if (timeout > 0L) {
                this.logger.info("");
                this.logger.info("Waiting for " + timeout + " seconds before cleaning the namespace");
                try {
                    Thread.sleep(timeout * 1000L);
                }
                catch (InterruptedException e) {
                    this.logger.info("Interrupted waiting to cleanup the namespace: " + e);
                }
            }
        }

        @Override
        public ResourceInstaller toImmutable() {
            return this;
        }
    }
}

