/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl;

import io.fabric8.kubernetes.api.model.v2_2.Endpoints;
import io.fabric8.kubernetes.api.model.v2_2.HasMetadata;
import io.fabric8.kubernetes.api.model.v2_2.Pod;
import io.fabric8.kubernetes.api.model.v2_2.PodList;
import io.fabric8.kubernetes.api.model.v2_2.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.v2_2.Service;
import io.fabric8.kubernetes.api.model.v2_2.ServiceList;
import io.fabric8.kubernetes.api.model.v2_2.ServicePort;
import io.fabric8.kubernetes.api.model.v2_2.extensions.ReplicaSetList;
import io.fabric8.kubernetes.clnt.v2_2.KubernetesClient;
import io.fabric8.kubernetes.clnt.v2_2.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.clnt.v2_2.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v2_2.dsl.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.arquillian.cube.impl.util.SystemEnvironmentVariables;
import org.arquillian.cube.kubernetes.api.AnnotationProvider;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.api.DependencyResolver;
import org.arquillian.cube.kubernetes.api.FeedbackProvider;
import org.arquillian.cube.kubernetes.api.KubernetesResourceLocator;
import org.arquillian.cube.kubernetes.api.Logger;
import org.arquillian.cube.kubernetes.api.NamespaceService;
import org.arquillian.cube.kubernetes.api.ResourceInstaller;
import org.arquillian.cube.kubernetes.api.Session;
import org.arquillian.cube.kubernetes.api.SessionCreatedListener;
import org.arquillian.cube.kubernetes.impl.ShutdownHook;
import org.arquillian.cube.kubernetes.impl.utils.ProcessUtil;
import org.jboss.arquillian.core.spi.Validate;

public class SessionManager
implements SessionCreatedListener {
    private final Session session;
    private final KubernetesClient client;
    private final Configuration configuration;
    private final AnnotationProvider annotationProvider;
    private final NamespaceService namespaceService;
    private final KubernetesResourceLocator kubernetesResourceLocator;
    private final DependencyResolver dependencyResolver;
    private final ResourceInstaller resourceInstaller;
    private final FeedbackProvider feedbackProvider;
    private final List<HasMetadata> resources = new ArrayList<HasMetadata>();
    private final AtomicReference<ShutdownHook> shutdownHookRef = new AtomicReference();

    public SessionManager(Session session, KubernetesClient client, Configuration configuration, AnnotationProvider annotationProvider, NamespaceService namespaceService, KubernetesResourceLocator kubernetesResourceLocator, DependencyResolver dependencyResolver, ResourceInstaller resourceInstaller, FeedbackProvider feedbackProvider) {
        Validate.notNull((Object)session, (String)"A Session instance is required.");
        Validate.notNull((Object)client, (String)"A KubernetesClient instance is required.");
        Validate.notNull((Object)configuration, (String)"Configuration is required.");
        Validate.notNull((Object)annotationProvider, (String)"An AnnotationProvider instance is required.");
        Validate.notNull((Object)namespaceService, (String)"A NamespaceService instance is required.");
        Validate.notNull((Object)dependencyResolver, (String)"A DependencyResolver instance is required.");
        Validate.notNull((Object)kubernetesResourceLocator, (String)"A KubernetesResourceLocator instance is required.");
        Validate.notNull((Object)resourceInstaller, (String)"A ResourceInstaller instance is required.");
        Validate.notNull((Object)feedbackProvider, (String)"A FeedbackProvider instance is required.");
        this.session = session;
        this.client = client;
        this.configuration = configuration;
        this.annotationProvider = annotationProvider;
        this.namespaceService = namespaceService;
        this.kubernetesResourceLocator = kubernetesResourceLocator;
        this.dependencyResolver = dependencyResolver;
        this.resourceInstaller = resourceInstaller;
        this.feedbackProvider = feedbackProvider;
    }

    private static String getSessionStatus(Session session) {
        if (session.getFailed().get() > 0) {
            return "FAILED";
        }
        return "PASSED";
    }

    public void createNamespace(Session session) {
        Map<String, String> namespaceAnnotations = this.annotationProvider.create(session.getId(), "RUNNING");
        if (!this.namespaceService.exists(session.getNamespace()).booleanValue()) {
            if (this.configuration.isNamespaceLazyCreateEnabled()) {
                this.namespaceService.create(session.getNamespace(), namespaceAnnotations);
            } else {
                throw new IllegalStateException("Namespace [" + session.getNamespace() + "] doesn't exist and lazily creation of namespaces is disabled. Either use an existing one, or set `namespace.lazy.enabled` to true.");
            }
        }
    }

    public void createEnvironment(Session session) {
        Logger log = session.getLogger();
        try {
            List<URL> dependencyUrls;
            URL configUrl = this.configuration.getEnvironmentConfigUrl();
            List<URL> list = dependencyUrls = !this.configuration.getEnvironmentDependencies().isEmpty() ? this.configuration.getEnvironmentDependencies() : this.dependencyResolver.resolve(session);
            if (this.configuration.isEnvironmentInitEnabled()) {
                if (this.configuration.getEnvironmentSetupScriptUrl() != null) {
                    this.setupEnvironment();
                }
                for (URL uRL : dependencyUrls) {
                    log.info("Found dependency: " + uRL);
                    this.resources.addAll(this.resourceInstaller.install(uRL));
                }
                if (configUrl == null) {
                    configUrl = this.kubernetesResourceLocator.locate();
                }
                if (configUrl != null) {
                    log.status("Applying kubernetes configuration from: " + configUrl);
                    Throwable throwable = null;
                    try (InputStream is = configUrl.openStream();){
                        this.resources.addAll(this.resourceInstaller.install(configUrl));
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                } else {
                    log.warn("Did not find any kubernetes configuration.");
                }
                List<URL> additionalUrls = this.configuration.getEnvironmentConfigAdditionalUrls();
                if (additionalUrls != null) {
                    for (URL uRL : additionalUrls) {
                        log.status("Applying additional kubernetes configuration from: " + uRL);
                        InputStream is = uRL.openStream();
                        Throwable throwable = null;
                        try {
                            this.resources.addAll(this.resourceInstaller.install(uRL));
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (is == null) continue;
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            is.close();
                        }
                    }
                }
                ArrayList<HasMetadata> arrayList = new ArrayList<HasMetadata>(this.resources);
                for (String service : this.configuration.getWaitForServiceList()) {
                    Endpoints endpoints = (Endpoints)((Resource)((NonNamespaceOperation)this.client.endpoints().inNamespace(session.getNamespace())).withName(service)).get();
                    if (endpoints == null) continue;
                    arrayList.add((HasMetadata)endpoints);
                }
                if (!arrayList.isEmpty()) {
                    try {
                        this.client.resourceList(arrayList).waitUntilReady(this.configuration.getWaitTimeout(), TimeUnit.MILLISECONDS);
                    }
                    catch (KubernetesClientTimeoutException kubernetesClientTimeoutException) {
                        log.warn("There are resources in not ready state:");
                        for (HasMetadata r : kubernetesClientTimeoutException.getResourcesNotReady()) {
                            log.error(r.getKind() + " name: " + r.getMetadata().getName() + " namespace:" + r.getMetadata().getNamespace());
                            this.feedbackProvider.onResourceNotReady(r);
                        }
                        throw new IllegalStateException("Environment not initialized in time.", kubernetesClientTimeoutException);
                    }
                }
            }
            this.display();
        }
        catch (Exception e) {
            try {
                this.clean("ERROR");
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void start() {
        Logger log = this.session.getLogger();
        log.status("Using Kubernetes at: " + this.client.getMasterUrl());
        this.createNamespace(this.session);
        this.addShutdownHook();
        try {
            this.createEnvironment(this.session);
        }
        catch (Throwable t) {
            this.removeShutdownHook();
            throw t;
        }
    }

    @Override
    public void stop() {
        try {
            this.clean(SessionManager.getSessionStatus(this.session));
        }
        finally {
            this.removeShutdownHook();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clean(String status) {
        String namespace = this.session.getNamespace();
        try {
            if (this.configuration.isNamespaceCleanupEnabled()) {
                this.resourceInstaller.uninstall(this.resources);
            }
            if (this.configuration.isNamespaceDestroyEnabled()) {
                this.namespaceService.destroy(namespace);
            } else {
                try {
                    this.namespaceService.annotate(this.session.getNamespace(), this.annotationProvider.create(this.session.getId(), status));
                }
                catch (Throwable t) {
                    this.session.getLogger().warn("Could not annotate namespace: [" + namespace + "] with status: [" + status + "].");
                }
            }
        }
        finally {
            this.tearDownEnvironment();
        }
    }

    @Override
    public void display() {
        ServiceList serviceList;
        PodList podList;
        ReplicationControllerList replicationControllerList;
        ReplicaSetList replicaSetList = (ReplicaSetList)((NonNamespaceOperation)this.client.extensions().replicaSets().inNamespace(this.session.getNamespace())).list();
        if (replicaSetList.getItems() != null) {
            for (Object replicaSet : replicaSetList.getItems()) {
                this.session.getLogger().info("ReplicaSet: [" + replicaSet.getMetadata().getName() + "]");
            }
        }
        if ((replicationControllerList = (ReplicationControllerList)((NonNamespaceOperation)this.client.replicationControllers().inNamespace(this.session.getNamespace())).list()).getItems() != null) {
            for (Object replicationController : replicationControllerList.getItems()) {
                this.session.getLogger().info("Replication controller: [" + replicationController.getMetadata().getName() + "]");
            }
        }
        if ((podList = (PodList)((NonNamespaceOperation)this.client.pods().inNamespace(this.session.getNamespace())).list()) != null) {
            for (Pod pod : podList.getItems()) {
                this.session.getLogger().info("Pod: [" + pod.getMetadata().getName() + "] Status: [" + pod.getStatus().getPhase() + "]");
            }
        }
        if ((serviceList = (ServiceList)((NonNamespaceOperation)this.client.services().inNamespace(this.session.getNamespace())).list()) != null) {
            for (Service service : serviceList.getItems()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Service: [").append(service.getMetadata().getName()).append("]").append(" IP: [").append(service.getSpec().getClusterIP()).append("]").append(" Ports: [ ");
                for (ServicePort servicePort : service.getSpec().getPorts()) {
                    sb.append(servicePort.getPort()).append(" ");
                }
                sb.append("]");
                this.session.getLogger().info(sb.toString());
            }
        }
    }

    private void setupEnvironment() {
        Logger log = this.session.getLogger();
        log.info("Executing environment setup script from:" + this.configuration.getEnvironmentSetupScriptUrl());
        try {
            ProcessUtil.runCommand(log, this.configuration.getEnvironmentSetupScriptUrl(), this.createScriptEnvironment());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void tearDownEnvironment() {
        if (this.configuration.getEnvironmentTeardownScriptUrl() != null) {
            try {
                this.session.getLogger().info("Executing environment teardown script from:" + this.configuration.getEnvironmentTeardownScriptUrl());
                ProcessUtil.runCommand(this.session.getLogger(), this.configuration.getEnvironmentTeardownScriptUrl(), this.createScriptEnvironment());
            }
            catch (IOException ex) {
                this.session.getLogger().warn("Failed to execute teardown script, due to: " + ex.getMessage());
            }
        }
    }

    private Map<String, String> createScriptEnvironment() {
        HashMap<String, String> env = new HashMap<String, String>();
        env.putAll(System.getenv());
        env.put(SystemEnvironmentVariables.propertyToEnvironmentVariableName((String)"kubernetes.namespace"), this.configuration.getNamespace());
        env.put(SystemEnvironmentVariables.propertyToEnvironmentVariableName((String)"kubernetes.domain"), this.configuration.getKubernetesDomain());
        env.put(SystemEnvironmentVariables.propertyToEnvironmentVariableName((String)"kubernetes.master"), this.configuration.getMasterUrl().toString());
        env.put(SystemEnvironmentVariables.propertyToEnvironmentVariableName((String)"docker.registry"), this.configuration.getDockerRegistry());
        return env;
    }

    private void addShutdownHook() {
        ShutdownHook hook = new ShutdownHook(new Runnable(){

            @Override
            public void run() {
                SessionManager.this.clean("ABORTED");
            }
        });
        Runtime.getRuntime().addShutdownHook(hook);
        this.shutdownHookRef.set(hook);
    }

    private void removeShutdownHook() {
        ShutdownHook hook = this.shutdownHookRef.get();
        if (hook != null) {
            Runtime.getRuntime().removeShutdownHook(hook);
        }
    }
}

