package org.arquillian.cube.kubernetes.impl;

import java.util.ArrayList;
import java.util.RandomAccess;
import org.arquillian.cube.kubernetes.api.Configuration;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.net.URL;
import java.util.AbstractList;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.v2_2.BaseFluent;
import io.fabric8.kubernetes.api.builder.v2_2.Fluent;
import io.fabric8.kubernetes.api.builder.v2_2.Visitable;

public class DefaultConfigurationFluentImpl<A extends DefaultConfigurationFluent<A>> extends BaseFluent<A> implements DefaultConfigurationFluent<A>{

     String sessionId;     String namespace;     URL masterUrl;     URL environmentSetupScriptUrl;     URL environmentTeardownScriptUrl;     URL environmentConfigUrl;     List<URL> environmentConfigAdditionalUrls = new ArrayList();     List<URL> environmentDependencies = new ArrayList();     boolean namespaceLazyCreateEnabled;     boolean namespaceCleanupEnabled;     long namespaceCleanupTimeout;     boolean namespaceCleanupConfirmationEnabled;     boolean namespaceDestroyEnabled;     boolean namespaceDestroyConfirmationEnabled;     long namespaceDestroyTimeout;     long waitTimeout;     long waitPollInterval;     List<String> waitForServiceList = new ArrayList();     boolean ansiLoggerEnabled;     boolean environmentInitEnabled;     String kubernetesDomain;     String dockerRegistry;
public DefaultConfigurationFluentImpl(){
    
}
public DefaultConfigurationFluentImpl( DefaultConfiguration instance ){
    this.withSessionId(instance.getSessionId()); this.withMasterUrl(instance.getMasterUrl()); this.withNamespace(instance.getNamespace()); this.withEnvironmentSetupScriptUrl(instance.getEnvironmentSetupScriptUrl()); this.withEnvironmentTeardownScriptUrl(instance.getEnvironmentTeardownScriptUrl()); this.withEnvironmentConfigUrl(instance.getEnvironmentConfigUrl()); this.withEnvironmentConfigAdditionalUrls(instance.getEnvironmentConfigAdditionalUrls()); this.withEnvironmentDependencies(instance.getEnvironmentDependencies()); this.withNamespaceLazyCreateEnabled(instance.isNamespaceLazyCreateEnabled()); this.withNamespaceCleanupEnabled(instance.isNamespaceCleanupEnabled()); this.withNamespaceCleanupTimeout(instance.getNamespaceCleanupTimeout()); this.withNamespaceCleanupConfirmationEnabled(instance.isNamespaceCleanupConfirmationEnabled()); this.withNamespaceDestroyEnabled(instance.isNamespaceDestroyEnabled()); this.withNamespaceDestroyConfirmationEnabled(instance.isNamespaceDestroyConfirmationEnabled()); this.withNamespaceDestroyTimeout(instance.getNamespaceDestroyTimeout()); this.withWaitTimeout(instance.getWaitTimeout()); this.withWaitPollInterval(instance.getWaitPollInterval()); this.withWaitForServiceList(instance.getWaitForServiceList()); this.withAnsiLoggerEnabled(instance.isAnsiLoggerEnabled()); this.withEnvironmentInitEnabled(instance.isEnvironmentInitEnabled()); this.withKubernetesDomain(instance.getKubernetesDomain()); this.withDockerRegistry(instance.getDockerRegistry()); 
}

    public String getSessionId(){
    return this.sessionId;
    }
    public A withSessionId( String sessionId){
    this.sessionId=sessionId; return (A) this;
    }
    public String getNamespace(){
    return this.namespace;
    }
    public A withNamespace( String namespace){
    this.namespace=namespace; return (A) this;
    }
    public URL getMasterUrl(){
    return this.masterUrl;
    }
    public A withMasterUrl( URL masterUrl){
    this.masterUrl=masterUrl; return (A) this;
    }
    public URL getEnvironmentSetupScriptUrl(){
    return this.environmentSetupScriptUrl;
    }
    public A withEnvironmentSetupScriptUrl( URL environmentSetupScriptUrl){
    this.environmentSetupScriptUrl=environmentSetupScriptUrl; return (A) this;
    }
    public URL getEnvironmentTeardownScriptUrl(){
    return this.environmentTeardownScriptUrl;
    }
    public A withEnvironmentTeardownScriptUrl( URL environmentTeardownScriptUrl){
    this.environmentTeardownScriptUrl=environmentTeardownScriptUrl; return (A) this;
    }
    public URL getEnvironmentConfigUrl(){
    return this.environmentConfigUrl;
    }
    public A withEnvironmentConfigUrl( URL environmentConfigUrl){
    this.environmentConfigUrl=environmentConfigUrl; return (A) this;
    }
    public A addToEnvironmentConfigAdditionalUrls( URL ...items){
    for (URL item : items) {this.environmentConfigAdditionalUrls.add(item);} return (A)this;
    }
    public A removeFromEnvironmentConfigAdditionalUrls( URL ...items){
    for (URL item : items) {this.environmentConfigAdditionalUrls.remove(item);} return (A)this;
    }
    public List<URL> getEnvironmentConfigAdditionalUrls(){
    return this.environmentConfigAdditionalUrls;
    }
    public A withEnvironmentConfigAdditionalUrls( List<URL> environmentConfigAdditionalUrls){
    this.environmentConfigAdditionalUrls.clear();if (environmentConfigAdditionalUrls != null) {for (URL item : environmentConfigAdditionalUrls){this.addToEnvironmentConfigAdditionalUrls(item);}} return (A) this;
    }
    public A withEnvironmentConfigAdditionalUrls( URL ...environmentConfigAdditionalUrls){
    this.environmentConfigAdditionalUrls.clear(); if (environmentConfigAdditionalUrls != null) {for (URL item :environmentConfigAdditionalUrls){ this.addToEnvironmentConfigAdditionalUrls(item);}} return (A) this;
    }
    public A addToEnvironmentDependencies( URL ...items){
    for (URL item : items) {this.environmentDependencies.add(item);} return (A)this;
    }
    public A removeFromEnvironmentDependencies( URL ...items){
    for (URL item : items) {this.environmentDependencies.remove(item);} return (A)this;
    }
    public List<URL> getEnvironmentDependencies(){
    return this.environmentDependencies;
    }
    public A withEnvironmentDependencies( List<URL> environmentDependencies){
    this.environmentDependencies.clear();if (environmentDependencies != null) {for (URL item : environmentDependencies){this.addToEnvironmentDependencies(item);}} return (A) this;
    }
    public A withEnvironmentDependencies( URL ...environmentDependencies){
    this.environmentDependencies.clear(); if (environmentDependencies != null) {for (URL item :environmentDependencies){ this.addToEnvironmentDependencies(item);}} return (A) this;
    }
    public boolean isNamespaceLazyCreateEnabled(){
    return this.namespaceLazyCreateEnabled;
    }
    public A withNamespaceLazyCreateEnabled( boolean namespaceLazyCreateEnabled){
    this.namespaceLazyCreateEnabled=namespaceLazyCreateEnabled; return (A) this;
    }
    public boolean isNamespaceCleanupEnabled(){
    return this.namespaceCleanupEnabled;
    }
    public A withNamespaceCleanupEnabled( boolean namespaceCleanupEnabled){
    this.namespaceCleanupEnabled=namespaceCleanupEnabled; return (A) this;
    }
    public long getNamespaceCleanupTimeout(){
    return this.namespaceCleanupTimeout;
    }
    public A withNamespaceCleanupTimeout( long namespaceCleanupTimeout){
    this.namespaceCleanupTimeout=namespaceCleanupTimeout; return (A) this;
    }
    public boolean isNamespaceCleanupConfirmationEnabled(){
    return this.namespaceCleanupConfirmationEnabled;
    }
    public A withNamespaceCleanupConfirmationEnabled( boolean namespaceCleanupConfirmationEnabled){
    this.namespaceCleanupConfirmationEnabled=namespaceCleanupConfirmationEnabled; return (A) this;
    }
    public boolean isNamespaceDestroyEnabled(){
    return this.namespaceDestroyEnabled;
    }
    public A withNamespaceDestroyEnabled( boolean namespaceDestroyEnabled){
    this.namespaceDestroyEnabled=namespaceDestroyEnabled; return (A) this;
    }
    public boolean isNamespaceDestroyConfirmationEnabled(){
    return this.namespaceDestroyConfirmationEnabled;
    }
    public A withNamespaceDestroyConfirmationEnabled( boolean namespaceDestroyConfirmationEnabled){
    this.namespaceDestroyConfirmationEnabled=namespaceDestroyConfirmationEnabled; return (A) this;
    }
    public long getNamespaceDestroyTimeout(){
    return this.namespaceDestroyTimeout;
    }
    public A withNamespaceDestroyTimeout( long namespaceDestroyTimeout){
    this.namespaceDestroyTimeout=namespaceDestroyTimeout; return (A) this;
    }
    public long getWaitTimeout(){
    return this.waitTimeout;
    }
    public A withWaitTimeout( long waitTimeout){
    this.waitTimeout=waitTimeout; return (A) this;
    }
    public long getWaitPollInterval(){
    return this.waitPollInterval;
    }
    public A withWaitPollInterval( long waitPollInterval){
    this.waitPollInterval=waitPollInterval; return (A) this;
    }
    public A addToWaitForServiceList( String ...items){
    for (String item : items) {this.waitForServiceList.add(item);} return (A)this;
    }
    public A removeFromWaitForServiceList( String ...items){
    for (String item : items) {this.waitForServiceList.remove(item);} return (A)this;
    }
    public List<String> getWaitForServiceList(){
    return this.waitForServiceList;
    }
    public A withWaitForServiceList( List<String> waitForServiceList){
    this.waitForServiceList.clear();if (waitForServiceList != null) {for (String item : waitForServiceList){this.addToWaitForServiceList(item);}} return (A) this;
    }
    public A withWaitForServiceList( String ...waitForServiceList){
    this.waitForServiceList.clear(); if (waitForServiceList != null) {for (String item :waitForServiceList){ this.addToWaitForServiceList(item);}} return (A) this;
    }
    public boolean isAnsiLoggerEnabled(){
    return this.ansiLoggerEnabled;
    }
    public A withAnsiLoggerEnabled( boolean ansiLoggerEnabled){
    this.ansiLoggerEnabled=ansiLoggerEnabled; return (A) this;
    }
    public boolean isEnvironmentInitEnabled(){
    return this.environmentInitEnabled;
    }
    public A withEnvironmentInitEnabled( boolean environmentInitEnabled){
    this.environmentInitEnabled=environmentInitEnabled; return (A) this;
    }
    public String getKubernetesDomain(){
    return this.kubernetesDomain;
    }
    public A withKubernetesDomain( String kubernetesDomain){
    this.kubernetesDomain=kubernetesDomain; return (A) this;
    }
    public String getDockerRegistry(){
    return this.dockerRegistry;
    }
    public A withDockerRegistry( String dockerRegistry){
    this.dockerRegistry=dockerRegistry; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
DefaultConfigurationFluentImpl that = (DefaultConfigurationFluentImpl) o;
if (sessionId != null ? !sessionId.equals(that.sessionId) :that.sessionId != null) return false;
if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
if (masterUrl != null ? !masterUrl.equals(that.masterUrl) :that.masterUrl != null) return false;
if (environmentSetupScriptUrl != null ? !environmentSetupScriptUrl.equals(that.environmentSetupScriptUrl) :that.environmentSetupScriptUrl != null) return false;
if (environmentTeardownScriptUrl != null ? !environmentTeardownScriptUrl.equals(that.environmentTeardownScriptUrl) :that.environmentTeardownScriptUrl != null) return false;
if (environmentConfigUrl != null ? !environmentConfigUrl.equals(that.environmentConfigUrl) :that.environmentConfigUrl != null) return false;
if (environmentConfigAdditionalUrls != null ? !environmentConfigAdditionalUrls.equals(that.environmentConfigAdditionalUrls) :that.environmentConfigAdditionalUrls != null) return false;
if (environmentDependencies != null ? !environmentDependencies.equals(that.environmentDependencies) :that.environmentDependencies != null) return false;
if (namespaceLazyCreateEnabled != that.namespaceLazyCreateEnabled) return false;
if (namespaceCleanupEnabled != that.namespaceCleanupEnabled) return false;
if (namespaceCleanupTimeout != that.namespaceCleanupTimeout) return false;
if (namespaceCleanupConfirmationEnabled != that.namespaceCleanupConfirmationEnabled) return false;
if (namespaceDestroyEnabled != that.namespaceDestroyEnabled) return false;
if (namespaceDestroyConfirmationEnabled != that.namespaceDestroyConfirmationEnabled) return false;
if (namespaceDestroyTimeout != that.namespaceDestroyTimeout) return false;
if (waitTimeout != that.waitTimeout) return false;
if (waitPollInterval != that.waitPollInterval) return false;
if (waitForServiceList != null ? !waitForServiceList.equals(that.waitForServiceList) :that.waitForServiceList != null) return false;
if (ansiLoggerEnabled != that.ansiLoggerEnabled) return false;
if (environmentInitEnabled != that.environmentInitEnabled) return false;
if (kubernetesDomain != null ? !kubernetesDomain.equals(that.kubernetesDomain) :that.kubernetesDomain != null) return false;
if (dockerRegistry != null ? !dockerRegistry.equals(that.dockerRegistry) :that.dockerRegistry != null) return false;
return true;

    }



}
