/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.config;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.Network;

public class DockerCompositions {
    private static final Logger logger = Logger.getLogger(DockerCompositions.class.getName());
    private Map<String, CubeContainer> containers = new LinkedHashMap<String, CubeContainer>();
    private Map<String, Network> networks = new LinkedHashMap<String, Network>();

    public Map<String, CubeContainer> getContainers() {
        return this.containers;
    }

    public Map<String, Network> getNetworks() {
        return this.networks;
    }

    public Set<String> getContainerIds() {
        return this.containers.keySet();
    }

    public Set<String> getNetworkIds() {
        return this.networks.keySet();
    }

    public void setNetworks(Map<String, Network> networks) {
        this.networks = networks;
    }

    public void setContainers(Map<String, CubeContainer> containers) {
        this.containers = containers;
    }

    public CubeContainer get(String id) {
        return this.containers.get(id);
    }

    public Network getNetwork(String id) {
        return this.networks.get(id);
    }

    public void add(String id, CubeContainer container) {
        this.containers.put(id, container);
    }

    public void add(String id, Network network) {
        this.networks.put(id, network);
    }

    public void merge(DockerCompositions otherContainers) {
        for (Map.Entry<String, Network> entry : this.networks.entrySet()) {
            if (otherContainers.getNetwork(entry.getKey()) == null) continue;
            entry.getValue().merge(otherContainers.getNetwork(entry.getKey()));
        }
        HashMap<String, Network> addAllNetworks = new HashMap<String, Network>();
        for (Map.Entry<String, Network> entry : otherContainers.getNetworks().entrySet()) {
            if (this.getNetwork(entry.getKey()) != null) continue;
            addAllNetworks.put(entry.getKey(), entry.getValue());
        }
        this.networks.putAll(addAllNetworks);
        for (Map.Entry<String, CubeContainer> entry : this.containers.entrySet()) {
            if (otherContainers.get(entry.getKey()) == null) continue;
            entry.getValue().merge(otherContainers.get(entry.getKey()));
        }
        HashMap<String, CubeContainer> hashMap = new HashMap<String, CubeContainer>();
        for (Map.Entry<String, CubeContainer> otherContainer : otherContainers.getContainers().entrySet()) {
            if (this.get(otherContainer.getKey()) != null) continue;
            hashMap.put(otherContainer.getKey(), otherContainer.getValue());
        }
        this.containers.putAll(hashMap);
    }

    public void overrideCubeProperties(DockerCompositions overrideDockerCompositions) {
        Set<String> containerIds = overrideDockerCompositions.getContainerIds();
        for (String containerId : containerIds) {
            if (this.containers.containsKey(containerId)) {
                CubeContainer cubeContainer = this.containers.get(containerId);
                CubeContainer overrideCubeContainer = overrideDockerCompositions.get(containerId);
                cubeContainer.setRemoveVolumes(overrideCubeContainer.getRemoveVolumes());
                if (overrideCubeContainer.hasAwait()) {
                    cubeContainer.setAwait(overrideCubeContainer.getAwait());
                }
                if (!overrideCubeContainer.hasBeforeStop()) continue;
                cubeContainer.setBeforeStop(overrideCubeContainer.getBeforeStop());
                continue;
            }
            logger.warning(String.format("Overriding Container %s are not defined in main definition of containers.", new Object[0]));
        }
    }
}

