/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.await;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.Info;
import com.github.dockerjava.core.async.ResultCallbackTemplate;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.regex.Pattern;
import org.arquillian.cube.docker.impl.await.SleepingAwaitStrategyBase;
import org.arquillian.cube.docker.impl.client.config.Await;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.docker.impl.util.Ping;
import org.arquillian.cube.docker.impl.util.PingCommand;
import org.arquillian.cube.spi.Cube;

public class LogScanningAwaitStrategy
extends SleepingAwaitStrategyBase {
    public static final String TAG = "log";
    private static final String REGEXP_PREFIX = "regexp:";
    private static final int DEFAULT_POLL_ITERATIONS = 10;
    private int pollIterations = 10;
    private boolean stdOut;
    private boolean stdErr;
    private Cube<?> cube;
    private DockerClientExecutor dockerClientExecutor;
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private final LogMatcher matcher;

    public LogScanningAwaitStrategy(Cube<?> cube, DockerClientExecutor dockerClientExecutor, Await params) {
        super(params.getSleepPollingTime());
        this.cube = cube;
        this.dockerClientExecutor = dockerClientExecutor;
        if (params.getIterations() != null) {
            this.pollIterations = params.getIterations();
        }
        this.stdOut = params.isStdOut();
        this.stdErr = params.isStdErr();
        this.matcher = params.getMatch().startsWith(REGEXP_PREFIX) ? new RegexpLogMatcher(params.getMatch().substring(REGEXP_PREFIX.length())) : new ContainsLogMatcher(params.getMatch());
    }

    public int getPollIterations() {
        return this.pollIterations;
    }

    public boolean isStdOut() {
        return this.stdOut;
    }

    public boolean isStdErr() {
        return this.stdErr;
    }

    public boolean await() {
        final DockerClient client = this.dockerClientExecutor.getDockerClient();
        Info info = (Info)client.infoCmd().exec();
        int since = this.parseTimestamp(info.getSystemTime());
        final LogContainerResultCallback callback = new LogContainerResultCallback(since);
        return Ping.ping(this.pollIterations, this.getSleepTime(), this.getTimeUnit(), new PingCommand(){

            @Override
            public boolean call() {
                try {
                    ((LogContainerResultCallback)client.logContainerCmd(LogScanningAwaitStrategy.this.cube.getId()).withStdOut(Boolean.valueOf(LogScanningAwaitStrategy.this.stdOut)).withStdErr(Boolean.valueOf(LogScanningAwaitStrategy.this.stdErr)).withTimestamps(Boolean.valueOf(true)).withSince(Integer.valueOf(callback.getLastTimestamp())).exec((ResultCallback)callback)).awaitCompletion();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return callback.isFound();
            }
        });
    }

    private int parseTimestamp(String s) {
        try {
            return (int)this.dateFormat.parse(s.substring(0, s.indexOf(46))).getTime() / 1000;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Timestamp parse failure: " + s, e);
        }
    }

    private static final class RegexpLogMatcher
    implements LogMatcher {
        private Pattern regex;

        public RegexpLogMatcher(String pattern) {
            this.regex = Pattern.compile(pattern, 32);
        }

        @Override
        public boolean match(String line) {
            return this.regex.matcher(line).matches();
        }
    }

    private static final class ContainsLogMatcher
    implements LogMatcher {
        private String substring;

        public ContainsLogMatcher(String substring) {
            this.substring = substring;
        }

        @Override
        public boolean match(String line) {
            return line.contains(this.substring);
        }
    }

    private static interface LogMatcher {
        public boolean match(String var1);
    }

    private class LogContainerResultCallback
    extends ResultCallbackTemplate<LogContainerResultCallback, Frame> {
        private int lastTimestamp;
        private boolean found;

        public LogContainerResultCallback(int since) {
            this.lastTimestamp = since;
        }

        public int getLastTimestamp() {
            return this.lastTimestamp;
        }

        public boolean isFound() {
            return this.found;
        }

        public void onNext(Frame item) {
            String line = new String(item.getPayload());
            this.lastTimestamp = LogScanningAwaitStrategy.this.parseTimestamp(line);
            if (!this.found) {
                this.found = LogScanningAwaitStrategy.this.matcher.match(line);
            }
        }
    }
}

