/*
 * Decompiled with CFR 0.152.
 */
package org.appsweaver.commons.mongo.models.criteria;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.appsweaver.commons.models.criteria.FilterableField;
import org.appsweaver.commons.models.persistence.QueryEntity;
import org.appsweaver.commons.spring.utilities.FrameworkHelper;
import org.appsweaver.commons.utilities.Stringizer;
import org.appsweaver.commons.utilities.TypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Criteria;

public class MongoFilterSpecification<T extends QueryEntity> {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    static final String EXPR_PREFIX = "(";
    static final String EXPR_SUFFIX = ")";
    final String operator;
    final String attribute;
    final String value;
    final Class<T> clazz;

    static boolean isExpression(String value) {
        if (value == null) {
            return false;
        }
        String trimmedValue = value.trim();
        return trimmedValue.contains(EXPR_PREFIX) && trimmedValue.endsWith(EXPR_SUFFIX);
    }

    static String getValue(String value) {
        return value.substring(value.indexOf(EXPR_PREFIX, 0) + 1, value.length() - EXPR_SUFFIX.length());
    }

    static String getOperator(String value) {
        return value.substring(0, value.indexOf(EXPR_PREFIX, 0));
    }

    public MongoFilterSpecification(Class<T> clazz, String attribute, String value) {
        this.clazz = clazz;
        if (!MongoFilterSpecification.isExpression(value)) {
            this.operator = "eq";
            this.attribute = attribute;
            this.value = value;
        } else {
            this.operator = MongoFilterSpecification.getOperator(value);
            this.attribute = attribute;
            this.value = MongoFilterSpecification.getValue(value);
        }
    }

    public void validate() throws SQLException {
        Map filterableAttributes = FrameworkHelper.getFilterableFields(this.clazz);
        if (!filterableAttributes.containsKey(this.attribute)) {
            throw new SQLException(String.format("Unsupported filterable attribute [name=%s]", this.attribute));
        }
    }

    final String getValue() {
        if (this.attribute.equals("id")) {
            if (this.operator.equals("in") || this.operator.equals("!in")) {
                Set values = TypeConverter.toSet((String)this.value, String.class);
                HashSet decoded = new HashSet(0);
                values.forEach(value -> {
                    if (StringUtils.isNumeric((CharSequence)value)) {
                        decoded.add(value);
                    } else {
                        decoded.add(value);
                    }
                });
                String csvString = Stringizer.toCSVString(decoded);
                return csvString;
            }
            if (StringUtils.isNumeric((CharSequence)this.value)) {
                return this.value;
            }
            return this.value;
        }
        return this.value;
    }

    final boolean isChild(String attribute) {
        String[] attribtuesAsArray = attribute.split("\\.");
        return attribtuesAsArray.length > 1;
    }

    final FilterableField resolveAttribute() throws SQLException {
        return (FilterableField)FrameworkHelper.getFilterableFields(this.clazz).get(this.attribute);
    }

    public Criteria toCriteria() {
        try {
            FilterableField attribute = this.resolveAttribute();
            if (attribute == null) {
                throw new UnsupportedOperationException(String.format("Filter not supported [attribute=%s, class=%s]", this.attribute, this.clazz.getName()));
            }
            switch (this.operator.toLowerCase()) {
                case "lt": {
                    return Criteria.where((String)attribute.getPath()).lt(TypeConverter.valueOf((Object)this.getValue(), Number.class));
                }
                case "le": {
                    return Criteria.where((String)attribute.getPath()).lte(TypeConverter.valueOf((Object)this.getValue(), Number.class));
                }
                case "gt": {
                    return Criteria.where((String)attribute.getPath()).gt(TypeConverter.valueOf((Object)this.getValue(), Number.class));
                }
                case "ge": {
                    return Criteria.where((String)attribute.getPath()).gte(TypeConverter.valueOf((Object)this.getValue(), Number.class));
                }
                case "in": 
                case "!in": {
                    Set collection = TypeConverter.toSet((String)this.getValue(), (Class)attribute.getType());
                    Criteria criteria = this.operator.startsWith("!") ? Criteria.where((String)attribute.getPath()).nin((Collection)collection) : Criteria.where((String)attribute.getPath()).in((Collection)collection);
                    return criteria;
                }
                case "eq": {
                    String value = this.getValue();
                    if (StringUtils.isNumeric((CharSequence)value)) {
                        return Criteria.where((String)attribute.getPath()).is(TypeConverter.valueOf((Object)value, Number.class));
                    }
                    return Criteria.where((String)attribute.getPath()).is(TypeConverter.valueOf((Object)value, (Class)attribute.getType()));
                }
                case "!eq": {
                    String value = this.getValue();
                    if (StringUtils.isNumeric((CharSequence)value)) {
                        return Criteria.where((String)attribute.getPath()).ne(TypeConverter.valueOf((Object)value, Number.class));
                    }
                    return Criteria.where((String)attribute.getPath()).ne(TypeConverter.valueOf((Object)value, (Class)attribute.getType()));
                }
                case "like": 
                case "!like": {
                    Criteria criteria = Criteria.where((String)attribute.getPath()).regex(this.getValue());
                    if (this.operator.startsWith("!")) {
                        criteria = criteria.norOperator(new Criteria[]{criteria});
                    }
                    return criteria;
                }
                case "between": 
                case "!between": {
                    String value = this.getValue();
                    String[] tokens = value.split(",");
                    Long start = (Long)TypeConverter.valueOf((Object)tokens[0], Long.class);
                    Long end = (Long)TypeConverter.valueOf((Object)tokens[1], Long.class);
                    Criteria criteria = Criteria.where((String)attribute.getPath()).gt((Object)start).lt((Object)end);
                    if (this.operator.startsWith("!")) {
                        criteria = criteria.norOperator(new Criteria[]{criteria});
                    }
                    return criteria;
                }
            }
            throw new UnsupportedOperationException(String.format("Operator [%s] not supported yet!", this.operator.toLowerCase()));
        }
        catch (Throwable t) {
            this.logger.debug(String.format("Unable to resolve attribute [class=%s, attribute=%s]", this.clazz.getName(), this.attribute), t);
            return null;
        }
    }
}

