/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.tool;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.appfuse.tool.DataHelper;
import org.appfuse.tool.NoXMLFormatArtifactCollector;
import org.appfuse.tool.StringUtils;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2x.ArtifactCollector;
import org.hibernate.tool.hbm2x.GenericExporter;
import org.hibernate.tool.hbm2x.pojo.POJOClass;
import org.springframework.core.io.ClassPathResource;

public class AppFuseExporter
extends GenericExporter {
    public AppFuseExporter() {
        this.init();
    }

    public AppFuseExporter(Configuration cfg, File outputdir) {
        super(cfg, outputdir);
        this.init();
    }

    public void init() {
        super.setArtifactCollector((ArtifactCollector)new NoXMLFormatArtifactCollector());
    }

    public String getName() {
        return "appfuse";
    }

    public void doStart() {
        String generateCore = this.getProperties().getProperty("generate-core");
        if (generateCore != null && generateCore.equals("true")) {
            this.generateCore();
        }
        String generateWeb = this.getProperties().getProperty("generate-web");
        if (!"true".equals(generateCore) && generateWeb != null && generateWeb.equals("true")) {
            this.generateWeb();
        }
        if (generateCore == null && generateWeb == null) {
            this.generateCore();
            this.generateWeb();
        }
    }

    private void generateCore() {
        String daoFramework;
        boolean genericCore = Boolean.valueOf(this.getProperties().getProperty("genericcore"));
        this.configureExporter("appfuse/dao/sample-data.ftl", "src/test/resources/{class-name}-sample-data.xml").start();
        if (genericCore) {
            this.configureExporter("appfuse/service/generic-beans.ftl", "src/main/resources/{class-name}-generic-beans.xml").start();
        } else {
            this.configureExporter("appfuse/dao/dao-test.ftl", "src/test/java/{basepkg-name}/dao/{class-name}DaoTest.java").start();
            this.configureExporter("appfuse/dao/dao.ftl", "src/main/java/{basepkg-name}/dao/{class-name}Dao.java").start();
            this.configureExporter("appfuse/dao/dao-bean.ftl", "src/main/resources/{class-name}Dao-bean.xml").start();
            daoFramework = this.getProperties().getProperty("daoframework");
            this.configureExporter("appfuse/dao/" + daoFramework + "/dao-impl.ftl", "src/main/java/{basepkg-name}/dao/" + daoFramework + "/{class-name}Dao" + this.getDaoFilename(daoFramework) + ".java").start();
            this.configureExporter("appfuse/service/manager-test.ftl", "src/test/java/{basepkg-name}/service/impl/{class-name}ManagerImplTest.java").start();
            this.configureExporter("appfuse/service/manager.ftl", "src/main/java/{basepkg-name}/service/{class-name}Manager.java").start();
            this.configureExporter("appfuse/service/manager-impl.ftl", "src/main/java/{basepkg-name}/service/impl/{class-name}ManagerImpl.java").start();
        }
        daoFramework = this.getProperties().getProperty("daoframework");
        if (daoFramework.equals("ibatis")) {
            this.configureExporter("appfuse/dao/ibatis/sql-map-config.ftl", "src/main/resources/{class-name}-sql-map-config.xml").start();
            this.configureExporter("appfuse/dao/ibatis/sql-map.ftl", "src/main/resources/sqlmaps/{class-name}SQL.xml").start();
            this.configureExporter("appfuse/dao/ibatis/compass-gps.ftl", "src/main/resources/compass-gps.xml").start();
            this.configureExporter("appfuse/dao/ibatis/select-ids.ftl", "src/main/resources/{class-name}-select-ids.xml").start();
        }
        this.configureExporter("appfuse/service/manager-bean.ftl", "src/main/resources/{class-name}Manager-bean.xml").start();
    }

    private void generateWeb() {
        boolean webProject;
        String packaging = this.getProperties().getProperty("packaging");
        boolean isAppFuse = Boolean.valueOf(this.getProperties().getProperty("isAppFuse"));
        boolean bl = webProject = packaging != null && packaging.equalsIgnoreCase("war");
        if (!webProject) {
            return;
        }
        String webFramework = this.getProperties().getProperty("webframework");
        ClassPathResource jwebUnitTemplate = new ClassPathResource("appfuse/web/" + webFramework + "/jwebunit-tests.ftl");
        if (webFramework.equalsIgnoreCase("jsf")) {
            this.configureExporter("appfuse/web/jsf/list-test.ftl", "src/test/java/{basepkg-name}/webapp/action/{class-name}ListTest.java").start();
            this.configureExporter("appfuse/web/jsf/form-test.ftl", "src/test/java/{basepkg-name}/webapp/action/{class-name}FormTest.java").start();
            this.configureExporter("appfuse/web/jsf/list.ftl", "src/main/java/{basepkg-name}/webapp/action/{class-name}List.java").start();
            this.configureExporter("appfuse/web/jsf/form.ftl", "src/main/java/{basepkg-name}/webapp/action/{class-name}Form.java").start();
            this.configureExporter("appfuse/web/jsf/list-view.ftl", "src/main/webapp/{class-name}s.xhtml").start();
            this.configureExporter("appfuse/web/jsf/form-view.ftl", "src/main/webapp/{class-name}Form.xhtml").start();
            this.configureExporter("appfuse/web/jsf/navigation.ftl", "src/main/webapp/WEB-INF/{class-name}-navigation.xml").start();
        } else if (webFramework.equalsIgnoreCase("spring") || webFramework.equalsIgnoreCase("spring-security") || webFramework.equalsIgnoreCase("spring-freemarker")) {
            this.configureExporter("appfuse/web/spring/controller-test.ftl", "src/test/java/{basepkg-name}/webapp/controller/{class-name}ControllerTest.java").start();
            this.configureExporter("appfuse/web/spring/formcontroller-test.ftl", "src/test/java/{basepkg-name}/webapp/controller/{class-name}FormControllerTest.java").start();
            this.configureExporter("appfuse/web/spring/controller.ftl", "src/main/java/{basepkg-name}/webapp/controller/{class-name}Controller.java").start();
            this.configureExporter("appfuse/web/spring/formcontroller.ftl", "src/main/java/{basepkg-name}/webapp/controller/{class-name}FormController.java").start();
            if (!webFramework.equalsIgnoreCase("spring-freemarker")) {
                this.configureExporter("appfuse/web/spring/list-view.ftl", "src/main/webapp/WEB-INF/pages/{class-name}s.jsp").start();
                this.configureExporter("appfuse/web/spring/form-view.ftl", "src/main/webapp/WEB-INF/pages/{class-name}form.jsp").start();
            } else {
                this.configureExporter("appfuse/web/spring-freemarker/list-view.ftl", "src/main/webapp/{class-name}list.ftl").start();
                this.configureExporter("appfuse/web/spring-freemarker/form-view.ftl", "src/main/webapp/{class-name}form.ftl").start();
            }
            this.configureExporter("appfuse/web/spring/form-validation.ftl", "src/main/webapp/WEB-INF/{class-name}-validation.xml").start();
        } else if (webFramework.equalsIgnoreCase("struts")) {
            this.configureExporter("appfuse/web/struts/action-test.ftl", "src/test/java/{basepkg-name}/webapp/action/{class-name}ActionTest.java").start();
            this.configureExporter("appfuse/web/struts/action.ftl", "src/main/java/{basepkg-name}/webapp/action/{class-name}Action.java").start();
            this.configureExporter("appfuse/web/struts/list-view.ftl", "src/main/webapp/WEB-INF/pages/{class-name}List.jsp").start();
            this.configureExporter("appfuse/web/struts/form-view.ftl", "src/main/webapp/WEB-INF/pages/{class-name}Form.jsp").start();
            this.configureExporter("appfuse/web/struts/action-beans.ftl", "src/main/webapp/WEB-INF/{class-name}-struts-bean.xml").start();
            GenericExporter exporter = this.configureExporter("appfuse/web/struts/struts.ftl", "src/main/resources/{class-name}-struts.xml");
            exporter.getProperties().put("pagesPath", isAppFuse ? "/WEB-INF/pages" : "");
            exporter.start();
            this.configureExporter("appfuse/web/struts/model-validation.ftl", "src/main/resources/{basepkg-name}/model/{class-name}-validation.xml").start();
            this.configureExporter("appfuse/web/struts/action-validation.ftl", "src/main/resources/{basepkg-name}/webapp/action/{class-name}Action-validation.xml").start();
        } else if (webFramework.equalsIgnoreCase("stripes")) {
            this.configureExporter("appfuse/web/stripes/list-action-test.ftl", "src/test/java/{basepkg-name}/webapp/action/{class-name}ListBeanTest.java").start();
            this.configureExporter("appfuse/web/stripes/form-action-test.ftl", "src/test/java/{basepkg-name}/webapp/action/{class-name}FormBeanTest.java").start();
            this.configureExporter("appfuse/web/stripes/list-action.ftl", "src/main/java/{basepkg-name}/webapp/action/{class-name}ListBean.java").start();
            this.configureExporter("appfuse/web/stripes/form-action.ftl", "src/main/java/{basepkg-name}/webapp/action/{class-name}FormBean.java").start();
            this.configureExporter("appfuse/web/stripes/list-view.ftl", "src/main/webapp/{class-name}List.jsp").start();
            this.configureExporter("appfuse/web/stripes/form-view.ftl", "src/main/webapp/{class-name}Form.jsp").start();
        } else if (webFramework.equalsIgnoreCase("tapestry")) {
            this.configureExporter("appfuse/web/tapestry/list-test.ftl", "src/test/java/{basepkg-name}/webapp/pages/{class-name}ListTest.java").start();
            this.configureExporter("appfuse/web/tapestry/form-test.ftl", "src/test/java/{basepkg-name}/webapp/pages/{class-name}FormTest.java").start();
            this.configureExporter("appfuse/web/tapestry/list.ftl", "src/main/java/{basepkg-name}/webapp/pages/{class-name}List.java").start();
            this.configureExporter("appfuse/web/tapestry/form.ftl", "src/main/java/{basepkg-name}/webapp/pages/{class-name}Form.java").start();
            this.configureExporter("appfuse/web/tapestry/list-view.ftl", "src/main/webapp/{class-name}List.tml").start();
            this.configureExporter("appfuse/web/tapestry/form-view.ftl", "src/main/webapp/{class-name}Form.tml").start();
        } else if (webFramework.equalsIgnoreCase("wicket")) {
            this.configureExporter("appfuse/web/wicket/list-test.ftl", "src/test/java/{basepkg-name}/webapp/pages/{class-name}ListTest.java").start();
            this.configureExporter("appfuse/web/wicket/form-test.ftl", "src/test/java/{basepkg-name}/webapp/pages/{class-name}FormTest.java").start();
            this.configureExporter("appfuse/web/wicket/model.ftl", "src/main/java/{basepkg-name}/webapp/pages/{class-name}Model.java").start();
            this.configureExporter("appfuse/web/wicket/data-provider.ftl", "src/main/java/{basepkg-name}/webapp/pages/Sortable{class-name}DataProvider.java").start();
            this.configureExporter("appfuse/web/wicket/list.ftl", "src/main/java/{basepkg-name}/webapp/pages/{class-name}List.java").start();
            this.configureExporter("appfuse/web/wicket/form.ftl", "src/main/java/{basepkg-name}/webapp/pages/{class-name}Form.java").start();
            this.configureExporter("appfuse/web/wicket/list-view.ftl", "src/main/java/{basepkg-name}/webapp/pages/{class-name}List.html").start();
            this.configureExporter("appfuse/web/wicket/form-view.ftl", "src/main/java/{basepkg-name}/webapp/pages/{class-name}Form.html").start();
        } else {
            this.log.warn((Object)("Your project's web framework '" + webFramework + "' is not supported by AMP at this time."));
            this.log.warn((Object)"See enter an issue in JIRA if you'd like to see support. http://issues.appfuse.org/browse/APF");
        }
        if (!webFramework.equalsIgnoreCase("tapestry")) {
            this.configureExporter("appfuse/web/menu.ftl", "src/main/webapp/common/{class-name}-menu.jsp").start();
            if (webFramework.equalsIgnoreCase("spring-freemarker")) {
                this.configureExporter("appfuse/web/menu-light-freemarker.ftl", "src/main/webapp/common/{class-name}-menu-light.ftl").start();
            } else {
                this.configureExporter("appfuse/web/menu-light.ftl", "src/main/webapp/common/{class-name}-menu-light.jsp").start();
            }
            this.configureExporter("appfuse/web/menu-config.ftl", "src/main/webapp/WEB-INF/{class-name}-menu-config.xml").start();
        } else {
            this.configureExporter("appfuse/web/tapestry/menu.ftl", "src/main/webapp/{class-name}-menu.tml").start();
        }
        this.configureExporter("appfuse/web/ApplicationResources.ftl", "src/main/resources/{class-name}-ApplicationResources.properties").start();
        if (!(webFramework.equals("spring-security") || webFramework.equalsIgnoreCase("spring-freemarker") || webFramework.equalsIgnoreCase("stripes"))) {
            this.configureExporter("appfuse/web/" + webFramework + "/web-tests.ftl", "src/test/resources/{class-name}-web-tests.xml").start();
        }
        if (webFramework.equalsIgnoreCase("spring-freemarker")) {
            webFramework = "spring";
            jwebUnitTemplate = new ClassPathResource("appfuse/web/" + webFramework + "/jwebunit-tests.ftl");
        }
        if (jwebUnitTemplate.exists()) {
            this.configureExporter("appfuse/web/" + webFramework + "/jwebunit-tests.ftl", "src/test/java/{basepkg-name}/webapp/{class-name}WebTest.java").start();
        }
    }

    private String getDaoFilename(String daoFramework) {
        if (daoFramework.equalsIgnoreCase("ibatis")) {
            return "iBatis";
        }
        if (daoFramework.equalsIgnoreCase("jpa")) {
            return "Jpa";
        }
        return Character.toUpperCase(daoFramework.charAt(0)) + daoFramework.substring(1);
    }

    private GenericExporter configureExporter(String template, String pattern) {
        String[] templatePaths;
        if (this.getProperties().getProperty("templatedirectory") != null) {
            templatePaths = new String[this.getTemplatePaths().length + 1];
            templatePaths[0] = this.getProperties().getProperty("templatedirectory");
            if (this.getTemplatePaths().length > 1) {
                for (int i = 1; i < this.getTemplatePaths().length; ++i) {
                    templatePaths[i] = this.getTemplatePaths()[i - 1];
                }
            }
        } else {
            templatePaths = this.getTemplatePaths();
        }
        GenericExporter exporter = new GenericExporter(this.getConfiguration(), this.getOutputDirectory()){

            protected void exportPOJO(Map map, POJOClass element) {
                if (element.getShortName().equals(System.getProperty("appfuse.entity"))) {
                    super.exportPOJO(map, element);
                }
            }

            protected String resolveFilename(POJOClass element) {
                String filename = super.resolveFilename(element);
                String packageLocation = this.getPackageNameForFile(element).replace(".", "/");
                String pojoName = System.getProperty("entity");
                if (pojoName == null) {
                    pojoName = System.getProperty("appfuse.entity");
                }
                if (pojoName.contains(".")) {
                    packageLocation = pojoName.substring(0, pojoName.indexOf(".model"));
                    packageLocation = packageLocation.replace(".", "/");
                }
                if (packageLocation.endsWith("model") && packageLocation.indexOf(47) > -1) {
                    packageLocation = packageLocation.substring(0, packageLocation.lastIndexOf(47));
                }
                filename = filename.replace("{basepkg-name}", packageLocation);
                return filename;
            }
        };
        exporter.setProperties((Properties)this.getProperties().clone());
        exporter.setTemplatePath(templatePaths);
        exporter.setTemplateName(template);
        exporter.setFilePattern(pattern);
        exporter.setArtifactCollector(this.getArtifactCollector());
        exporter.getProperties().put("data", new DataHelper());
        exporter.getProperties().put("util", new StringUtils());
        return exporter;
    }
}

