/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.mojo.installer;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Replace;
import org.appfuse.mojo.installer.AntUtils;
import org.appfuse.tool.ArtifactUninstaller;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

public class UninstallArtifactsMojo
extends AbstractMojo {
    private Prompter prompter;
    private MavenProject project;
    private String installedDirectory;
    private boolean genericCore;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String daoFramework;
        if (this.project.getPackaging().equalsIgnoreCase("pom")) {
            String errorMsg = "[ERROR] This plugin cannot be run from a pom project, please run it from a jar or war project (i.e. core or web).";
            throw new MojoFailureException(errorMsg);
        }
        String pojoName = System.getProperty("entity");
        if (pojoName == null) {
            try {
                pojoName = this.prompter.prompt("What is the name of your pojo (i.e. Person)?");
            }
            catch (PrompterException pe) {
                pe.printStackTrace();
            }
        }
        if (!"true".equals(System.getProperty("skip.areyousure"))) {
            try {
                String text = "WARNING: ALL artifacts will be removed, including your model object!";
                text = text + "\nAre you sure you want to remove '" + pojoName + ".java' and all related artifacts? [Y/N]";
                String proceed = this.prompter.prompt(text);
                if (!"Y".equalsIgnoreCase(proceed)) {
                    this.log("Cancelling removal at your request.");
                    return;
                }
                this.log("Proceeding... let's hope you're using source control!");
            }
            catch (PrompterException pe) {
                pe.printStackTrace();
            }
        }
        if (pojoName == null) {
            throw new MojoExecutionException("You must specify an entity name to continue.");
        }
        ArtifactUninstaller uninstaller = new ArtifactUninstaller(this.project, pojoName, this.installedDirectory, this.genericCore);
        uninstaller.execute();
        String hibernateCfgLocation = this.installedDirectory + "/src/main/resources/hibernate.cfg.xml";
        if (this.project.getPackaging().equals("war") && this.project.hasParent() && !this.project.getParentArtifact().getGroupId().contains("appfuse")) {
            String moduleName = (String)this.project.getParent().getModules().get(0);
            String pathToParent = this.project.getOriginalModel().getParent().getRelativePath();
            pathToParent = pathToParent.substring(0, pathToParent.lastIndexOf(47) + 1);
            this.log("Assuming '" + moduleName + "' has hibernate.cfg.xml in its src/main/resources directory");
            hibernateCfgLocation = this.project.getBasedir() + "/" + pathToParent + moduleName + "/src/main/resources/hibernate.cfg.xml";
        }
        if ((daoFramework = (String)this.project.getProperties().get("dao.framework")) == null) {
            this.getLog().error((CharSequence)"[ERROR] No <dao.framework> property found in pom.xml. Please add this property.");
        }
        if ("hibernate".equals(daoFramework)) {
            this.log("Removing mapping for '" + pojoName + "' from hibernate.cfg.xml");
            String className = this.project.getGroupId() + ".model." + pojoName;
            Project antProject = AntUtils.createProject();
            Replace replace = (Replace)antProject.createTask("replace");
            replace.setFile(new File(hibernateCfgLocation));
            replace.setToken("    <mapping class=\"" + className + "\"/>");
            replace.execute();
        }
        this.log("Removal succeeded! Please run 'mvn clean' to remove any compiled classes.");
    }

    private void log(String msg) {
        this.getLog().info((CharSequence)("[AppFuse] " + msg));
    }
}

