/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.mojo.installer;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.appfuse.tool.ArtifactInstaller;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

public class InstallArtifactsMojo
extends AbstractMojo {
    Prompter prompter;
    private MavenProject project;
    private String destinationDirectory;
    private String sourceDirectory;
    private boolean genericCore;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project.getPackaging().equalsIgnoreCase("pom")) {
            String errorMsg = "Doh! This plugin cannot be run from a pom project, please run it from a jar or war project (i.e. core or web).";
            throw new MojoFailureException(errorMsg);
        }
        String pojoName = System.getProperty("entity");
        if (pojoName == null) {
            try {
                pojoName = this.prompter.prompt("What is the name of your pojo (i.e. Person)?");
            }
            catch (PrompterException pe) {
                pe.printStackTrace();
            }
        }
        if (pojoName == null) {
            throw new MojoExecutionException("You must specify an entity name to continue.");
        }
        ArtifactInstaller installer = new ArtifactInstaller(this.project, pojoName, this.sourceDirectory, this.destinationDirectory, this.genericCore);
        installer.execute();
    }
}

