/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.mojo.exporter;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.appfuse.mojo.HibernateExporterMojo;
import org.hibernate.tool.hbm2x.Exporter;
import org.hibernate.tool.hbm2x.POJOExporter;

public class ModelGeneratorMojo
extends HibernateExporterMojo {
    private String destinationDirectory;
    private String sourceDirectory;
    private boolean disableInstallation;
    private String templateDirectory;

    public ModelGeneratorMojo() {
        this.addDefaultComponent("target/appfuse/generated-sources", "configuration", false);
        this.addDefaultComponent("target/appfuse/generated-sources", "jdbcconfiguration", true);
        this.addDefaultComponent("target/appfuse/generated-sources", "annotationconfiguration", true);
    }

    public String getName() {
        return "gen-model";
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        File existingConfig;
        this.getComponentProperties().put("implementation", "jdbcconfiguration");
        this.getComponentProperties().put("outputDirectory", this.sourceDirectory != null ? this.sourceDirectory : "${basedir}/target/appfuse/generated-sources");
        File revengFile = new File("src/test/resources/hibernate.reveng.xml");
        if (revengFile.exists() && this.getComponentProperty("revengfile") == null) {
            this.getComponentProperties().put("revengfile", "src/test/resources/hibernate.reveng.xml");
        }
        if (this.getComponentProperty("revengfile") == null) {
            this.getComponentProperties().put("revengfile", "target/test-classes/hibernate.reveng.xml");
        }
        if (!(existingConfig = new File(this.getComponentProperty("revengfile"))).exists()) {
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/appfuse/model/hibernate.reveng.ftl");
            StringBuffer configFile = new StringBuffer();
            try {
                String line;
                InputStreamReader isr = new InputStreamReader(in);
                BufferedReader reader = new BufferedReader(isr);
                while ((line = reader.readLine()) != null) {
                    configFile.append(line).append("\n");
                }
                reader.close();
                this.getLog().info((CharSequence)("Writing 'hibernate.reveng.xml' to " + existingConfig.getPath()));
                FileUtils.writeStringToFile((File)existingConfig, (String)configFile.toString());
            }
            catch (IOException io) {
                throw new MojoFailureException(io.getMessage());
            }
        }
        if (this.getComponentProperty("packagename") == null) {
            this.getComponentProperties().put("packagename", this.getProject().getGroupId() + ".model");
        }
        if (this.getComponentProperty("configurationfile") == null) {
            File jdbcProperties = new File("target/classes/jdbc.properties");
            if (!jdbcProperties.exists()) {
                jdbcProperties = new File("target/test-classes/jdbc.properties");
            }
            if (jdbcProperties.exists()) {
                if (this.getComponentProperty("propertyfile") == null) {
                    this.getComponentProperties().put("propertyfile", jdbcProperties.getPath());
                    this.getLog().debug((CharSequence)("Set propertyfile to '" + jdbcProperties.getPath() + "'"));
                }
            } else {
                throw new MojoFailureException("Failed to find jdbc.properties in classpath.");
            }
        }
        super.doExecute();
        if (System.getProperty("disableInstallation") != null) {
            this.disableInstallation = Boolean.valueOf(System.getProperty("disableInstallation"));
        }
        if (!this.disableInstallation) {
            try {
                String packageName = this.getComponentProperties().get("packagename");
                String packageAsDir = packageName.replaceAll("\\.", "/");
                File dir = new File(this.sourceDirectory + "/" + packageAsDir);
                if (dir.exists()) {
                    Iterator filesIterator = FileUtils.iterateFiles((File)dir, (String[])new String[]{"java"}, (boolean)false);
                    while (filesIterator.hasNext()) {
                        File f = (File)filesIterator.next();
                        this.getLog().info((CharSequence)("Copying generated '" + f.getName() + "' to project..."));
                        FileUtils.copyFileToDirectory((File)f, (File)new File(this.destinationDirectory + "/src/main/java/" + packageAsDir));
                    }
                } else {
                    throw new MojoFailureException("No tables found in database to generate code from.");
                }
                FileUtils.forceDelete((File)dir);
            }
            catch (IOException io) {
                throw new MojoFailureException(io.getMessage());
            }
        }
    }

    @Override
    protected Exporter configureExporter(Exporter exp) throws MojoExecutionException {
        String[] templatePaths;
        this.getProject().addCompileSourceRoot(new File(this.getComponent().getOutputDirectory()).getPath());
        POJOExporter exporter = (POJOExporter)super.configureExporter(exp);
        if (this.templateDirectory != null) {
            templatePaths = new String[exporter.getTemplatePaths().length + 1];
            templatePaths[0] = this.templateDirectory;
            if (exporter.getTemplatePaths().length > 1) {
                for (int i = 1; i < exporter.getTemplatePaths().length; ++i) {
                    templatePaths[i] = exporter.getTemplatePaths()[i - 1];
                }
            }
        } else {
            templatePaths = exporter.getTemplatePaths();
        }
        exporter.setTemplatePath(templatePaths);
        exporter.setTemplateName("appfuse/model/Pojo.ftl");
        exporter.getProperties().setProperty("basepackage", this.getProject().getGroupId());
        exporter.getProperties().setProperty("ejb3", this.getComponentProperty("ejb3", "true"));
        exporter.getProperties().setProperty("jdk5", this.getComponentProperty("jdk5", "true"));
        if (this.isFullSource()) {
            exporter.getProperties().setProperty("appfusepackage", this.getProject().getGroupId());
        } else {
            exporter.getProperties().setProperty("appfusepackage", "org.appfuse");
        }
        return exporter;
    }

    @Override
    protected Exporter createExporter() {
        return new POJOExporter();
    }
}

