/*
 * Decompiled with CFR 0.152.
 */
package org.apmem.tools.layouts;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import org.apmem.tools.layouts.R;

class LayoutConfiguration {
    private int horizontalSpacing = 0;
    private int verticalSpacing = 0;
    private int orientation = 0;
    private boolean debugDraw = false;
    private float weightDefault = 0.0f;
    private int gravity = 51;
    private int layoutDirection = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LayoutConfiguration(Context context, AttributeSet attributeSet) {
        TypedArray a = context.obtainStyledAttributes(attributeSet, R.styleable.FlowLayout);
        try {
            this.setHorizontalSpacing(a.getDimensionPixelSize(1, 0));
            this.setVerticalSpacing(a.getDimensionPixelSize(2, 0));
            this.setOrientation(a.getInteger(3, 0));
            this.setDebugDraw(a.getBoolean(5, false));
            this.setWeightDefault(a.getFloat(6, 0.0f));
            this.setGravity(a.getInteger(0, 0));
            this.setLayoutDirection(a.getInteger(4, 0));
        }
        finally {
            a.recycle();
        }
    }

    public int getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public void setHorizontalSpacing(int horizontalSpacing) {
        this.horizontalSpacing = Math.max(0, horizontalSpacing);
    }

    public int getVerticalSpacing() {
        return this.verticalSpacing;
    }

    public void setVerticalSpacing(int verticalSpacing) {
        this.verticalSpacing = Math.max(0, verticalSpacing);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation == 1 ? orientation : 0;
    }

    public boolean isDebugDraw() {
        return this.debugDraw;
    }

    public void setDebugDraw(boolean debugDraw) {
        this.debugDraw = debugDraw;
    }

    public float getWeightDefault() {
        return this.weightDefault;
    }

    public void setWeightDefault(float weightDefault) {
        this.weightDefault = Math.max(0.0f, weightDefault);
    }

    public int getGravity() {
        return this.gravity;
    }

    public void setGravity(int gravity) {
        if ((gravity & 7) == 0) {
            gravity |= 3;
        }
        if ((gravity & 0x70) == 0) {
            gravity |= 0x30;
        }
        this.gravity = gravity;
    }

    public int getLayoutDirection() {
        return this.layoutDirection;
    }

    public void setLayoutDirection(int layoutDirection) {
        this.layoutDirection = layoutDirection == 1 ? layoutDirection : 0;
    }
}

