/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.samples;

import java.io.IOException;
import java.io.PrintWriter;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.samples.ApfloatHolder;
import org.apfloat.samples.BackgroundOperation;
import org.apfloat.samples.Operation;
import org.apfloat.samples.Pi;

public class PiParallel
extends Pi {
    private static final boolean DEBUG = false;

    PiParallel() {
    }

    public static void main(String[] args) throws IOException, ApfloatRuntimeException {
        Operation<Apfloat> operation;
        if (args.length < 1) {
            System.err.println("USAGE: PiParallel digits [method] [threads] [radix]");
            System.err.println("    radix must be 2...36");
            return;
        }
        long precision = PiParallel.getPrecision(args[0]);
        int method = args.length > 1 ? PiParallel.getInt(args[1], "method", 0, 1) : 0;
        int numberOfProcessors = args.length > 2 ? PiParallel.getInt(args[2], "threads", 1, Integer.MAX_VALUE) : ApfloatContext.getContext().getNumberOfProcessors();
        int radix = args.length > 3 ? PiParallel.getRadix(args[3]) : ApfloatContext.getContext().getDefaultRadix();
        ApfloatContext ctx = ApfloatContext.getContext();
        ctx.setNumberOfProcessors(numberOfProcessors);
        ctx.setExecutorService(ApfloatContext.getDefaultExecutorService());
        switch (method) {
            case 0: {
                operation = new ParallelChudnovskyPiCalculator(precision, radix);
                break;
            }
            default: {
                operation = new ParallelRamanujanPiCalculator(precision, radix);
            }
        }
        PiParallel.setOut(new PrintWriter(System.out, true));
        PiParallel.setErr(new PrintWriter(System.err, true));
        PiParallel.run(precision, radix, operation);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ThreadLimitedOperation<T>
    implements Operation<T> {
        private Operation<T> operation;
        private int numberOfProcessors;

        public ThreadLimitedOperation(Operation<T> operation, int numberOfProcessors) {
            this.operation = operation;
            this.numberOfProcessors = numberOfProcessors;
        }

        @Override
        public T execute() {
            Pi.checkAlive();
            ApfloatContext threadCtx = ApfloatContext.getThreadContext();
            ApfloatContext ctx = (ApfloatContext)ApfloatContext.getContext().clone();
            ctx.setNumberOfProcessors(this.numberOfProcessors);
            ApfloatContext.setThreadContext((ApfloatContext)ctx);
            T result = this.operation.execute();
            if (threadCtx != null) {
                ApfloatContext.setThreadContext((ApfloatContext)threadCtx);
            } else {
                ApfloatContext.removeThreadContext();
            }
            return result;
        }
    }

    public static class ParallelRamanujanPiCalculator
    extends Pi.RamanujanPiCalculator {
        public ParallelRamanujanPiCalculator(long precision, int radix) throws ApfloatRuntimeException {
            this(new ParallelBinarySplittingPiCalculator(new Pi.RamanujanBinarySplittingSeries(precision, radix)), precision, radix);
        }

        protected ParallelRamanujanPiCalculator(Pi.BinarySplittingPiCalculator calculator, long precision, int radix) throws ApfloatRuntimeException {
            super(calculator, precision, radix);
        }

        public Apfloat execute() {
            ApfloatContext ctx = ApfloatContext.getContext();
            int numberOfProcessors = ctx.getNumberOfProcessors();
            if (numberOfProcessors > 1) {
                Pi.err.println("Using up to " + numberOfProcessors + " parallel operations for calculation");
            }
            return super.execute();
        }
    }

    public static class ParallelChudnovskyPiCalculator
    extends Pi.ChudnovskyPiCalculator {
        public ParallelChudnovskyPiCalculator(long precision, int radix) throws ApfloatRuntimeException {
            this(new ParallelBinarySplittingPiCalculator(new Pi.ChudnovskyBinarySplittingSeries(precision, radix)), precision, radix);
        }

        protected ParallelChudnovskyPiCalculator(Pi.BinarySplittingPiCalculator calculator, long precision, int radix) throws ApfloatRuntimeException {
            super(calculator, precision, radix);
        }

        public Apfloat execute() {
            ApfloatContext ctx = ApfloatContext.getContext();
            int numberOfProcessors = ctx.getNumberOfProcessors();
            if (numberOfProcessors > 1) {
                Pi.err.println("Using up to " + numberOfProcessors + " parallel operations for calculation");
            }
            return super.execute();
        }
    }

    protected static class ParallelBinarySplittingPiCalculator
    extends Pi.BinarySplittingPiCalculator {
        public ParallelBinarySplittingPiCalculator(Pi.BinarySplittingSeries series) throws ApfloatRuntimeException {
            super(series);
        }

        public void r(final long n1, final long n2, final ApfloatHolder T, final ApfloatHolder Q, final ApfloatHolder P, final Pi.BinarySplittingProgressIndicator progressIndicator) throws ApfloatRuntimeException {
            Pi.checkAlive();
            ApfloatContext ctx = ApfloatContext.getContext();
            int numberOfProcessors = ctx.getNumberOfProcessors();
            if (n1 == n2) {
                T.setApfloat((Apfloat)Apfloat.ZERO);
                Q.setApfloat((Apfloat)Apfloat.ONE);
                if (P != null) {
                    P.setApfloat((Apfloat)Apfloat.ONE);
                }
            } else if (numberOfProcessors == 1) {
                super.r(n1, n2, T, Q, P, progressIndicator);
            } else {
                final ApfloatHolder LT = new ApfloatHolder();
                final ApfloatHolder LQ = new ApfloatHolder();
                final ApfloatHolder LP = new ApfloatHolder();
                if (ParallelBinarySplittingPiCalculator.split(n1, n2, numberOfProcessors)) {
                    int numberOfProcessors1 = numberOfProcessors / 2;
                    int numberOfProcessors2 = numberOfProcessors - numberOfProcessors1;
                    final long nMiddle = n1 + (n2 - n1) * (long)numberOfProcessors1 / (long)numberOfProcessors;
                    Operation<Object> operation1 = new Operation<Object>(){

                        @Override
                        public Object execute() {
                            ParallelBinarySplittingPiCalculator.this.r(n1, nMiddle, LT, LQ, LP, progressIndicator);
                            return null;
                        }
                    };
                    Operation<Object> operation2 = new Operation<Object>(){

                        @Override
                        public Object execute() {
                            ParallelBinarySplittingPiCalculator.this.r(nMiddle, n2, T, Q, P, progressIndicator);
                            return null;
                        }
                    };
                    BackgroundOperation<Object> operation = new BackgroundOperation<Object>(new ThreadLimitedOperation<Object>(operation1, numberOfProcessors1));
                    new ThreadLimitedOperation<Object>(operation2, numberOfProcessors2).execute();
                    operation.getResult();
                } else {
                    long nMiddle = (n1 + n2) / 2L;
                    this.r(n1, nMiddle, LT, LQ, LP, progressIndicator);
                    this.r(nMiddle, n2, T, Q, P, progressIndicator);
                }
                T.setApfloat(Q.getApfloat().multiply(LT.getApfloat()).add(LP.getApfloat().multiply(T.getApfloat())));
                Q.setApfloat(LQ.getApfloat().multiply(Q.getApfloat()));
                if (P != null) {
                    P.setApfloat(LP.getApfloat().multiply(P.getApfloat()));
                }
                if (progressIndicator != null) {
                    progressIndicator.progress(n1, n2);
                }
            }
        }

        private static boolean split(long n1, long n2, int numberOfProcessors) {
            long termsPerThread = (n2 - n1) / (long)numberOfProcessors;
            ApfloatContext ctx = ApfloatContext.getContext();
            long threshold = ctx.getSharedMemoryTreshold() / 32L;
            return termsPerThread < threshold;
        }
    }
}

