/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.samples;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apfloat.samples.Operation;

public class OperationServer {
    private static final int BUFFER_SIZE = 8192;
    private static final int ERROR = 0;
    private static final int WARNING = 1;
    private static final int INFO = 2;
    private static final int DEBUG = 3;
    private static int messageLevel = 1;

    private OperationServer() {
    }

    public static void main(String[] args) throws IOException {
        int port;
        int workerThreads = 1;
        if (args.length < 1) {
            System.err.println("USAGE: OperationServer port [workerThreads] [messageLevel]");
            return;
        }
        try {
            port = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException nfe) {
            System.err.println("Invalid port: " + args[0]);
            return;
        }
        try {
            if (args.length > 1 && (workerThreads = Integer.parseInt(args[1])) <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            System.err.println("Invalid number of workerThreads: " + args[0]);
            return;
        }
        try {
            if (args.length > 2) {
                messageLevel = Integer.parseInt(args[2]);
            }
        }
        catch (NumberFormatException nfe) {
            System.err.println("Invalid messageLevel: " + args[0]);
            return;
        }
        Selector selector = Selector.open();
        ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
        serverSocketChannel.configureBlocking(false);
        serverSocketChannel.socket().bind(new InetSocketAddress(port));
        SelectionKey serverKey = serverSocketChannel.register(selector, 16);
        ExecutorService executor = Executors.newFixedThreadPool(workerThreads);
        OperationServer.info("Waiting for connections to port " + port);
        block6: while (true) {
            selector.select();
            Set<SelectionKey> keys = selector.selectedKeys();
            Iterator<SelectionKey> i = keys.iterator();
            while (true) {
                if (!i.hasNext()) continue block6;
                SelectionKey key = i.next();
                i.remove();
                if (key != serverKey || !key.isAcceptable()) continue;
                SocketChannel clientSocketChannel = serverSocketChannel.accept();
                OperationServer.info("New connection accepted");
                executor.execute(new Request(clientSocketChannel));
            }
            break;
        }
    }

    private static void warning(String message, Exception e) {
        if (messageLevel >= 1) {
            System.err.println("WARNING: " + Thread.currentThread().getName() + ": " + message);
            e.printStackTrace(System.err);
        }
    }

    private static void info(String message) {
        if (messageLevel >= 2) {
            System.err.println("INFO: " + Thread.currentThread().getName() + ": " + message);
        }
    }

    private static void debug(String message) {
        if (messageLevel >= 3) {
            System.err.println("DEBUG: " + Thread.currentThread().getName() + ": " + message);
        }
    }

    private static class Request
    implements Runnable {
        private SocketChannel channel;

        public Request(SocketChannel channel) {
            this.channel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                OperationServer.info("Request processing started");
                ObjectInputStream in = new ObjectInputStream(Channels.newInputStream(this.channel));
                OperationServer.info("Ready to receive input data");
                Operation operation = (Operation)in.readObject();
                OperationServer.info("Executing operation");
                Object result = operation.execute();
                ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(Channels.newOutputStream(this.channel), 8192));
                OperationServer.info("Ready to write output data");
                out.writeObject(result);
                out.flush();
                OperationServer.info("Request processing complete");
            }
            catch (Exception e) {
                OperationServer.warning("Request processing failed", e);
            }
            finally {
                try {
                    this.channel.socket().shutdownOutput();
                    this.channel.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

