/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.samples;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Label;
import java.awt.TextField;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.samples.Operation;
import org.apfloat.samples.Pi;
import org.apfloat.samples.PiAWT;
import org.apfloat.samples.PiParallel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PiParallelAWT
extends PiAWT {
    private Label threadsLabel;
    private TextField threadsField;

    public PiParallelAWT(PiAWT.StatusIndicator statusIndicator) {
        super(statusIndicator);
    }

    @Override
    protected void initThreads(Container container, GridBagConstraints constraints) {
        this.threadsLabel = new Label("Threads:");
        container.add((Component)this.threadsLabel, constraints);
        this.threadsField = new TextField(ApfloatContext.getContext().getProperty("numberOfProcessors"), 5);
        constraints.gridwidth = 0;
        container.add((Component)this.threadsField, constraints);
    }

    @Override
    protected boolean isInputValid() {
        if (!super.isInputValid()) {
            return false;
        }
        String threadsString = this.threadsField.getText();
        try {
            int threads = Integer.parseInt(threadsString);
            if (threads <= 0) {
                throw new NumberFormatException();
            }
            this.showStatus(null);
            return true;
        }
        catch (NumberFormatException nfe) {
            this.showStatus("Invalid number of threads: " + threadsString);
            this.threadsField.requestFocus();
            return false;
        }
    }

    @Override
    protected Operation<Apfloat> getOperation(long precision, int radix) throws ApfloatRuntimeException {
        ApfloatContext ctx = ApfloatContext.getContext();
        int numberOfProcessors = Integer.parseInt(this.threadsField.getText());
        ctx.setNumberOfProcessors(numberOfProcessors);
        Operation<Apfloat> operation = super.getOperation(precision, radix);
        if (operation instanceof Pi.ChudnovskyPiCalculator) {
            operation = new PiParallel.ParallelChudnovskyPiCalculator(precision, radix);
        } else if (operation instanceof Pi.RamanujanPiCalculator) {
            operation = new PiParallel.ParallelRamanujanPiCalculator(precision, radix);
        }
        return operation;
    }
}

