/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.jscience;

import javolution.context.LocalContext;
import org.apfloat.Apint;
import org.apfloat.ApintMath;
import org.apfloat.jscience.AbstractField;

public class ModuloApintField
extends AbstractField<ModuloApintField, Apint> {
    private static final long serialVersionUID = 5308452222350777004L;
    private static final LocalContext.Reference<Apint> MODULUS = new LocalContext.Reference();

    public ModuloApintField(Apint value) {
        super(ModuloApintField.reduce(value));
    }

    public static Apint getModulus() {
        return (Apint)MODULUS.get();
    }

    public static void setModulus(Apint modulus) {
        if (modulus != null && modulus.signum() <= 0) {
            throw new IllegalArgumentException("Modulus has to be greater than zero");
        }
        MODULUS.set((Object)modulus);
    }

    public static Apint reduce(Apint value) {
        Apint modulus = (Apint)MODULUS.get();
        if (modulus != null && (value = value.mod(modulus)).signum() < 0) {
            value = value.add(modulus);
        }
        return value;
    }

    @Override
    public ModuloApintField plus(ModuloApintField that) {
        return new ModuloApintField(((Apint)this.value()).add((Apint)that.value()));
    }

    @Override
    public ModuloApintField opposite() {
        return new ModuloApintField(((Apint)this.value()).negate());
    }

    @Override
    public ModuloApintField times(ModuloApintField that) {
        return new ModuloApintField(((Apint)this.value()).multiply((Apint)that.value()));
    }

    @Override
    public ModuloApintField inverse() throws ArithmeticException {
        Apint modulus = (Apint)MODULUS.get();
        if (modulus == null) {
            throw new ArithmeticException("Modulus is not set");
        }
        return new ModuloApintField(ApintMath.modPow((Apint)((Apint)this.value()), (Apint)new Apint(-1L), (Apint)modulus));
    }

    @Override
    public ModuloApintField copy() {
        return new ModuloApintField((Apint)this.value());
    }
}

