/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.jscience;

import javolution.context.LocalContext;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatArithmeticException;
import org.apfloat.Apint;
import org.apfloat.ApintMath;
import org.apfloat.jscience.AbstractField;

public class ModuloApintField
extends AbstractField<ModuloApintField, Apint> {
    static final XMLFormat<ModuloApintField> XML = new XMLFormat<ModuloApintField>(ModuloApintField.class){

        public ModuloApintField newInstance(Class<ModuloApintField> cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return new ModuloApintField(AbstractField.parse("", xml).truncate());
        }

        public void write(ModuloApintField field, XMLFormat.OutputElement xml) throws XMLStreamException {
            AbstractField.format((Apfloat)field.value(), "", xml, null);
        }

        public void read(XMLFormat.InputElement xml, ModuloApintField field) throws XMLStreamException {
        }
    };
    private static final long serialVersionUID = 5308452222350777004L;
    private static final LocalContext.Reference<Apint> MODULUS = new LocalContext.Reference();

    public ModuloApintField(Apint value) {
        super(ModuloApintField.reduce(value));
    }

    public static Apint getModulus() {
        return (Apint)MODULUS.get();
    }

    public static void setModulus(Apint modulus) {
        if (modulus != null && modulus.signum() <= 0) {
            throw new IllegalArgumentException("Modulus has to be greater than zero");
        }
        MODULUS.set((Object)modulus);
    }

    public static Apint reduce(Apint value) {
        Apint modulus = (Apint)MODULUS.get();
        if (modulus != null && (value = value.mod(modulus)).signum() < 0) {
            value = value.add(modulus);
        }
        return value;
    }

    @Override
    public ModuloApintField plus(ModuloApintField that) {
        return new ModuloApintField(((Apint)this.value()).add((Apint)that.value()));
    }

    @Override
    public ModuloApintField opposite() {
        return new ModuloApintField(((Apint)this.value()).negate());
    }

    @Override
    public ModuloApintField times(ModuloApintField that) {
        return new ModuloApintField(((Apint)this.value()).multiply((Apint)that.value()));
    }

    @Override
    public ModuloApintField inverse() throws ArithmeticException {
        Apint modulus = (Apint)MODULUS.get();
        if (modulus == null) {
            throw new ApfloatArithmeticException("Modulus is not set");
        }
        return new ModuloApintField(ApintMath.modPow((Apint)((Apint)this.value()), (Apint)new Apint(-1L), (Apint)modulus));
    }

    public ModuloApintField pow(Apint exp) {
        Apint modulus = (Apint)MODULUS.get();
        if (modulus == null) {
            throw new ApfloatArithmeticException("Modulus is not set");
        }
        return new ModuloApintField(ApintMath.modPow((Apint)((Apint)this.value()), (Apint)exp, (Apint)modulus));
    }

    @Override
    public ModuloApintField copy() {
        return new ModuloApintField((Apint)this.value());
    }
}

