/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.aparapi;

import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicInteger;
import org.apfloat.aparapi.LongKernel;
import org.apfloat.internal.NTTStrategyDecorator;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.NTTStrategy;

public interface LongAparapiNTTStrategy
extends NTTStrategy,
NTTStrategyDecorator {
    public static final ThreadLocal<AtomicInteger> LEVEL = ThreadLocal.withInitial(AtomicInteger::new);
    public static final ThreadLocal<WeakReference<long[]>> DATA = ThreadLocal.withInitial(() -> new WeakReference<Object>(null));

    default public void beforeTransform(ArrayAccess arrayAccess) {
        long[] data = arrayAccess.getLongData();
        AtomicInteger currentLevel = LEVEL.get();
        long[] currentData = (long[])DATA.get().get();
        if (currentLevel.get() == 0 || data != currentData) {
            LongKernel kernel = LongKernel.getInstance();
            kernel.setExplicit(true);
            kernel.put(data);
            DATA.set(new WeakReference<long[]>(data));
            currentLevel.set(0);
        }
        currentLevel.incrementAndGet();
    }

    default public void afterTransform(ArrayAccess arrayAccess) {
        AtomicInteger level = LEVEL.get();
        int currentLevel = level.decrementAndGet();
        if (currentLevel == 0) {
            LongKernel kernel = LongKernel.getInstance();
            kernel.get(arrayAccess.getLongData());
            kernel.cleanUpArrays();
        }
    }
}

