/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.aparapi;

import com.aparapi.Range;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.aparapi.IntKernel;
import org.apfloat.aparapi.RangeHelper;
import org.apfloat.internal.IntModConstants;
import org.apfloat.internal.IntNTTStepStrategy;
import org.apfloat.internal.IntWTables;
import org.apfloat.internal.Scramble;
import org.apfloat.spi.ArrayAccess;

public class IntAparapiNTTStepStrategy
extends IntNTTStepStrategy {
    public void multiplyElements(ArrayAccess arrayAccess, int startRow, int startColumn, int rows, int columns, long length, long totalTransformLength, boolean isInverse, int modulus) throws ApfloatRuntimeException {
        this.setModulus(IntModConstants.MODULUS[modulus]);
        int w = isInverse ? this.getInverseNthRoot(IntModConstants.PRIMITIVE_ROOT[modulus], length) : this.getForwardNthRoot(IntModConstants.PRIMITIVE_ROOT[modulus], length);
        int scaleFactor = isInverse ? this.modDivide(1, (int)totalTransformLength) : 1;
        IntKernel kernel = IntKernel.getInstance();
        kernel.setOp(5);
        kernel.setArrayAccess(arrayAccess);
        kernel.setStartRow(startRow);
        kernel.setStartColumn(startColumn);
        kernel.setRows(rows);
        kernel.setColumns(columns);
        kernel.setW(w);
        kernel.setScaleFactor(scaleFactor);
        kernel.setModulus(IntModConstants.MODULUS[modulus]);
        Range range = RangeHelper.create(columns);
        kernel.execute(range);
    }

    public void transformRows(ArrayAccess arrayAccess, int length, int count, boolean isInverse, boolean permute, int modulus) throws ApfloatRuntimeException {
        int[] wTable = isInverse ? IntWTables.getInverseWTable((int)modulus, (int)length) : IntWTables.getWTable((int)modulus, (int)length);
        int[] permutationTable = permute ? Scramble.createScrambleTable((int)length) : null;
        IntKernel kernel = IntKernel.getInstance();
        kernel.setOp(isInverse ? 2 : 1);
        kernel.setLength(length);
        kernel.setArrayAccess(arrayAccess);
        kernel.setWTable(wTable);
        kernel.setPermutationTable(permutationTable);
        kernel.setModulus(IntModConstants.MODULUS[modulus]);
        kernel.put(wTable);
        if (permutationTable != null) {
            kernel.put(permutationTable);
        }
        Range range = RangeHelper.create(count);
        kernel.execute(range);
    }
}

