/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.aparapi;

import com.aparapi.Range;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.aparapi.IntKernel;
import org.apfloat.aparapi.RangeHelper;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.IntFactor3NTTStepStrategy;
import org.apfloat.internal.IntModConstants;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.DataStorage;

public class IntAparapiFactor3NTTStepStrategy
extends IntFactor3NTTStepStrategy {
    public void transformColumns(DataStorage dataStorage0, DataStorage dataStorage1, DataStorage dataStorage2, long startColumn, long columns, long power2length, long length, boolean isInverse, int modulus) throws ApfloatRuntimeException {
        assert (length == 3L * power2length);
        if (!(dataStorage0.isCached() && dataStorage1.isCached() && dataStorage2.isCached() && startColumn <= Integer.MAX_VALUE && columns <= Integer.MAX_VALUE)) {
            throw new ApfloatInternalException("Data must be stored in memory");
        }
        ArrayAccess arrayAccess0 = dataStorage0.getArray(3, startColumn, (int)columns);
        ArrayAccess arrayAccess1 = dataStorage1.getArray(3, startColumn, (int)columns);
        ArrayAccess arrayAccess2 = dataStorage2.getArray(3, startColumn, (int)columns);
        if (arrayAccess0.getIntData() != arrayAccess1.getIntData() || arrayAccess1.getIntData() != arrayAccess2.getIntData() || (long)arrayAccess1.getOffset() != (long)arrayAccess0.getOffset() + columns || (long)arrayAccess2.getOffset() != (long)arrayAccess1.getOffset() + columns) {
            throw new ApfloatInternalException("Data must be stored consecutively in memory");
        }
        this.setModulus(IntModConstants.MODULUS[modulus]);
        int w = isInverse ? this.getInverseNthRoot(IntModConstants.PRIMITIVE_ROOT[modulus], length) : this.getForwardNthRoot(IntModConstants.PRIMITIVE_ROOT[modulus], length);
        int w3 = this.modPow(w, (int)power2length);
        int ww = this.modMultiply(w, w);
        int w1 = this.negate(this.modDivide(3, 2));
        int w2 = this.modAdd(w3, this.modDivide(1, 2));
        IntKernel kernel = IntKernel.getInstance();
        kernel.setOp(isInverse ? 7 : 6);
        kernel.setArrayAccess(arrayAccess0);
        kernel.setStartColumn((int)startColumn);
        kernel.setColumns((int)columns);
        kernel.setW(w);
        kernel.setWw(ww);
        kernel.setW1(w1);
        kernel.setW2(w2);
        kernel.setModulus(IntModConstants.MODULUS[modulus]);
        Range range = RangeHelper.create((int)columns);
        kernel.execute(range);
    }
}

