/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.aparapi;

import org.apfloat.ApfloatContext;
import org.apfloat.aparapi.ColumnTwoPassFNTStrategy;
import org.apfloat.aparapi.LongAparapiFactor3NTTStrategy;
import org.apfloat.aparapi.LongAparapiNTTStepStrategy;
import org.apfloat.aparapi.LongAparapiSixStepFNTStrategy;
import org.apfloat.internal.LongNTTBuilder;
import org.apfloat.spi.BuilderFactory;
import org.apfloat.spi.NTTStepStrategy;
import org.apfloat.spi.NTTStrategy;

public class LongAparapiNTTBuilder
extends LongNTTBuilder {
    private static final int MIN_GPU_LENGTH = 0x100000;

    protected NTTStrategy createSixStepFNTStrategy(long size) {
        long length = size;
        if (length < 0x100000L) {
            return super.createSixStepFNTStrategy(size);
        }
        return new LongAparapiSixStepFNTStrategy();
    }

    protected NTTStrategy createTwoPassFNTStrategy(long size) {
        long length = size;
        if (length < 0x100000L) {
            return super.createTwoPassFNTStrategy(size);
        }
        return new ColumnTwoPassFNTStrategy((NTTStepStrategy)new LongAparapiNTTStepStrategy());
    }

    protected NTTStrategy createFactor3NTTStrategy(long size, NTTStrategy nttStrategy) {
        if (nttStrategy instanceof LongAparapiSixStepFNTStrategy) {
            ApfloatContext ctx = ApfloatContext.getContext();
            BuilderFactory builderFactory = ctx.getBuilderFactory();
            long maxMemoryBlockSize = ctx.getMaxMemoryBlockSize() / (long)builderFactory.getElementSize();
            if (size <= maxMemoryBlockSize && size <= Integer.MAX_VALUE) {
                return new LongAparapiFactor3NTTStrategy();
            }
        }
        return super.createFactor3NTTStrategy(size, nttStrategy);
    }
}

