/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.client.boot.configuration;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.ArrayList;
import org.apereo.cas.client.util.AbstractConfigurationFilter;
import org.apereo.cas.client.validation.Assertion;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;

public class SpringSecurityAssertionSessionContextFilter
extends AbstractConfigurationFilter {
    private final AuthenticationUserDetailsService userDetailsService;
    private final String[] attributes;

    public SpringSecurityAssertionSessionContextFilter(AuthenticationUserDetailsService userDetailsService, String ... attributes) {
        this.userDetailsService = userDetailsService;
        this.attributes = attributes;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpSession session = request.getSession();
        if (session != null && session.getAttribute("_const_cas_assertion_") != null) {
            Assertion assertion = (Assertion)session.getAttribute("_const_cas_assertion_");
            CasAuthenticationToken authentication = new CasAuthenticationToken(assertion);
            UserDetails userDetails = this.userDetailsService.loadUserDetails((Authentication)authentication);
            authentication.getAuthorities().addAll(userDetails.getAuthorities());
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private static class CasAuthenticationToken
    extends AbstractAuthenticationToken {
        private static final long serialVersionUID = -270498735829222143L;
        private final Assertion assertion;

        public CasAuthenticationToken(Assertion assertion) {
            super(new ArrayList());
            this.assertion = assertion;
        }

        public Object getCredentials() {
            return null;
        }

        public Object getPrincipal() {
            return this.assertion.getPrincipal().getName();
        }
    }
}

