/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.ResponseBuilder;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.saml.SamlCoreProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.authentication.SamlResponseBuilder;
import org.apereo.cas.support.saml.authentication.principal.SamlServiceResponseBuilder;
import org.apereo.cas.support.saml.util.Saml10ObjectBuilder;
import org.apereo.cas.support.saml.web.SamlValidateController;
import org.apereo.cas.support.saml.web.SamlValidateEndpoint;
import org.apereo.cas.support.saml.web.view.Saml10FailureResponseView;
import org.apereo.cas.support.saml.web.view.Saml10SuccessResponseView;
import org.apereo.cas.ticket.proxy.ProxyHandler;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.validation.AuthenticationAttributeReleasePolicy;
import org.apereo.cas.validation.CasProtocolValidationSpecification;
import org.apereo.cas.validation.RequestedAuthenticationContextValidator;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizersExecutionPlan;
import org.apereo.cas.web.ProtocolEndpointConfigurer;
import org.apereo.cas.web.ServiceValidateConfigurationContext;
import org.apereo.cas.web.ServiceValidationViewFactory;
import org.apereo.cas.web.ServiceValidationViewFactoryConfigurer;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.view.attributes.NoOpProtocolAttributesRenderer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.View;

@Configuration(value="samlConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SamlConfiguration {
    @Autowired
    @Qualifier(value="serviceValidationViewFactory")
    private ObjectProvider<ServiceValidationViewFactory> serviceValidationViewFactory;
    @Autowired
    @Qualifier(value="argumentExtractor")
    private ObjectProvider<ArgumentExtractor> argumentExtractor;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ObjectProvider<ServiceFactory<WebApplicationService>> webApplicationServiceFactory;
    @Autowired
    @Qualifier(value="casAttributeEncoder")
    private ObjectProvider<ProtocolAttributeEncoder> protocolAttributeEncoder;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private ObjectProvider<AuthenticationServiceSelectionPlan> authenticationServiceSelectionPlan;
    @Autowired
    @Qualifier(value="proxy20Handler")
    private ObjectProvider<ProxyHandler> proxy20Handler;
    @Autowired
    @Qualifier(value="shibboleth.OpenSAMLConfig")
    private ObjectProvider<OpenSamlConfigBean> openSamlConfigBean;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private ObjectProvider<CentralAuthenticationService> centralAuthenticationService;
    @Autowired
    @Qualifier(value="authenticationAttributeReleasePolicy")
    private ObjectProvider<AuthenticationAttributeReleasePolicy> authenticationAttributeReleasePolicy;
    @Autowired
    @Qualifier(value="requestedContextValidator")
    private ObjectProvider<RequestedAuthenticationContextValidator> requestedContextValidator;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport;
    @Autowired
    @Qualifier(value="cas20WithoutProxyProtocolValidationSpecification")
    private ObjectProvider<CasProtocolValidationSpecification> cas20WithoutProxyProtocolValidationSpecification;
    @Autowired
    @Qualifier(value="serviceValidationAuthorizers")
    private ObjectProvider<ServiceTicketValidationAuthorizersExecutionPlan> validationAuthorizers;
    @Autowired
    @Qualifier(value="registeredServiceAccessStrategyEnforcer")
    private ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer;

    @ConditionalOnMissingBean(name={"samlResponseBuilder"})
    @RefreshScope
    @Bean
    public SamlResponseBuilder samlResponseBuilder() {
        SamlCoreProperties samlCore = this.casProperties.getSamlCore();
        return new SamlResponseBuilder(this.saml10ObjectBuilder(), samlCore.getIssuer(), samlCore.getAttributeNamespace(), samlCore.getIssueLength(), samlCore.getSkewAllowance(), (ProtocolAttributeEncoder)this.protocolAttributeEncoder.getObject(), (ServicesManager)this.servicesManager.getObject());
    }

    @ConditionalOnMissingBean(name={"casSamlServiceSuccessView"})
    @RefreshScope
    @Bean
    public View casSamlServiceSuccessView() {
        return new Saml10SuccessResponseView((ProtocolAttributeEncoder)this.protocolAttributeEncoder.getObject(), (ServicesManager)this.servicesManager.getObject(), (ArgumentExtractor)this.argumentExtractor.getObject(), StandardCharsets.UTF_8.name(), (AuthenticationAttributeReleasePolicy)this.authenticationAttributeReleasePolicy.getObject(), (AuthenticationServiceSelectionPlan)this.authenticationServiceSelectionPlan.getObject(), NoOpProtocolAttributesRenderer.INSTANCE, this.samlResponseBuilder());
    }

    @ConditionalOnMissingBean(name={"casSamlServiceFailureView"})
    @RefreshScope
    @Bean
    public View casSamlServiceFailureView() {
        return new Saml10FailureResponseView((ProtocolAttributeEncoder)this.protocolAttributeEncoder.getObject(), (ServicesManager)this.servicesManager.getObject(), (ArgumentExtractor)this.argumentExtractor.getObject(), StandardCharsets.UTF_8.name(), (AuthenticationAttributeReleasePolicy)this.authenticationAttributeReleasePolicy.getObject(), (AuthenticationServiceSelectionPlan)this.authenticationServiceSelectionPlan.getObject(), NoOpProtocolAttributesRenderer.INSTANCE, this.samlResponseBuilder());
    }

    @ConditionalOnMissingBean(name={"samlServiceResponseBuilder"})
    @Bean
    public ResponseBuilder samlServiceResponseBuilder() {
        return new SamlServiceResponseBuilder((ServicesManager)this.servicesManager.getObject());
    }

    @ConditionalOnMissingBean(name={"saml10ObjectBuilder"})
    @Bean
    public Saml10ObjectBuilder saml10ObjectBuilder() {
        return new Saml10ObjectBuilder((OpenSamlConfigBean)this.openSamlConfigBean.getObject());
    }

    @Bean
    public SamlValidateController samlValidateController() {
        ServiceValidateConfigurationContext context = ServiceValidateConfigurationContext.builder().validationSpecifications(CollectionUtils.wrapSet((Object)((CasProtocolValidationSpecification)this.cas20WithoutProxyProtocolValidationSpecification.getObject()))).authenticationSystemSupport((AuthenticationSystemSupport)this.authenticationSystemSupport.getObject()).servicesManager((ServicesManager)this.servicesManager.getObject()).centralAuthenticationService((CentralAuthenticationService)this.centralAuthenticationService.getObject()).argumentExtractor((ArgumentExtractor)this.argumentExtractor.getObject()).proxyHandler((ProxyHandler)this.proxy20Handler.getObject()).requestedContextValidator((RequestedAuthenticationContextValidator)this.requestedContextValidator.getObject()).authnContextAttribute(this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute()).validationAuthorizers((ServiceTicketValidationAuthorizersExecutionPlan)this.validationAuthorizers.getObject()).renewEnabled(this.casProperties.getSso().isRenewAuthnEnabled()).validationViewFactory((ServiceValidationViewFactory)this.serviceValidationViewFactory.getObject()).build();
        return new SamlValidateController(context);
    }

    @Bean
    public ProtocolEndpointConfigurer samlProtocolEndpointConfigurer() {
        return () -> List.of(StringUtils.prependIfMissing((String)"/samlValidate", (CharSequence)"/", (CharSequence[])new CharSequence[0]));
    }

    @Bean
    public ServiceValidationViewFactoryConfigurer samlServiceValidationViewFactoryConfigurer() {
        return factory -> factory.registerView(SamlValidateController.class, Pair.of((Object)this.casSamlServiceSuccessView(), (Object)this.casSamlServiceFailureView()));
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    public SamlValidateEndpoint samlValidateEndpoint() {
        return new SamlValidateEndpoint(this.casProperties, (ServicesManager)this.servicesManager.getObject(), (AuthenticationSystemSupport)this.authenticationSystemSupport.getObject(), (ServiceFactory<WebApplicationService>)((ServiceFactory)this.webApplicationServiceFactory.getObject()), PrincipalFactoryUtils.newPrincipalFactory(), this.samlResponseBuilder(), (OpenSamlConfigBean)this.openSamlConfigBean.getObject(), (AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject());
    }
}

