/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.authentication.SamlResponseBuilder;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml1.core.Response;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="samlValidate", enableByDefault=false)
public class SamlValidateEndpoint
extends BaseCasActuatorEndpoint {
    private final ServicesManager servicesManager;
    private final AuthenticationSystemSupport authenticationSystemSupport;
    private final ServiceFactory<WebApplicationService> serviceFactory;
    private final PrincipalFactory principalFactory;
    private final SamlResponseBuilder samlResponseBuilder;
    private final OpenSamlConfigBean openSamlConfigBean;

    public SamlValidateEndpoint(CasConfigurationProperties casProperties, ServicesManager servicesManager, AuthenticationSystemSupport authenticationSystemSupport, ServiceFactory<WebApplicationService> serviceFactory, PrincipalFactory principalFactory, SamlResponseBuilder samlResponseBuilder, OpenSamlConfigBean openSamlConfigBean) {
        super(casProperties);
        this.servicesManager = servicesManager;
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.serviceFactory = serviceFactory;
        this.principalFactory = principalFactory;
        this.samlResponseBuilder = samlResponseBuilder;
        this.openSamlConfigBean = openSamlConfigBean;
    }

    @ReadOperation
    public Map<String, Object> handle(String username, String password, String service) {
        WebApplicationService selectedService = (WebApplicationService)this.serviceFactory.createService(service);
        RegisteredService registeredService = this.servicesManager.findServiceBy((Service)selectedService);
        UsernamePasswordCredential credential = new UsernamePasswordCredential(username, password);
        AuthenticationResult result = this.authenticationSystemSupport.handleAndFinalizeSingleAuthenticationTransaction((Service)selectedService, new Credential[]{credential});
        Authentication authentication = result.getAuthentication();
        Principal principal = authentication.getPrincipal();
        Map attributesToRelease = registeredService.getAttributeReleasePolicy().getAttributes(principal, (Service)selectedService, registeredService);
        String principalId = registeredService.getUsernameAttributeProvider().resolveUsername(principal, (Service)selectedService, registeredService);
        Principal modifiedPrincipal = this.principalFactory.createPrincipal(principalId, attributesToRelease);
        AuthenticationBuilder builder = DefaultAuthenticationBuilder.newInstance((Authentication)authentication);
        builder.setPrincipal(modifiedPrincipal);
        Authentication finalAuthentication = builder.build();
        Response samlResponse = this.samlResponseBuilder.createResponse(selectedService.getId(), selectedService);
        this.samlResponseBuilder.prepareSuccessfulResponse(samlResponse, (Service)selectedService, finalAuthentication, principal, finalAuthentication.getAttributes(), principal.getAttributes());
        LinkedHashMap<String, Object> resValidation = new LinkedHashMap<String, Object>();
        String encoded = SamlUtils.transformSamlObject((OpenSamlConfigBean)this.openSamlConfigBean, (XMLObject)samlResponse).toString();
        resValidation.put("assertion", encoded);
        resValidation.put("service", selectedService);
        resValidation.put("registeredService", registeredService);
        return resValidation;
    }
}

