/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.nio.charset.StandardCharsets;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.principal.ResponseBuilder;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.saml.SamlCoreProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.authentication.principal.SamlServiceResponseBuilder;
import org.apereo.cas.support.saml.util.Saml10ObjectBuilder;
import org.apereo.cas.support.saml.web.SamlValidateController;
import org.apereo.cas.support.saml.web.view.Saml10FailureResponseView;
import org.apereo.cas.support.saml.web.view.Saml10SuccessResponseView;
import org.apereo.cas.ticket.proxy.ProxyHandler;
import org.apereo.cas.validation.AuthenticationAttributeReleasePolicy;
import org.apereo.cas.validation.CasProtocolAttributesRenderer;
import org.apereo.cas.validation.CasProtocolValidationSpecification;
import org.apereo.cas.validation.RequestedContextValidator;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizersExecutionPlan;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.view.attributes.NoOpProtocolAttributesRenderer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.View;

@Configuration(value="samlConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SamlConfiguration {
    @Autowired
    @Qualifier(value="argumentExtractor")
    private ObjectProvider<ArgumentExtractor> argumentExtractor;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="casAttributeEncoder")
    private ObjectProvider<ProtocolAttributeEncoder> protocolAttributeEncoder;
    @Autowired
    @Qualifier(value="cas3ServiceJsonView")
    private ObjectProvider<View> cas3ServiceJsonView;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private ObjectProvider<AuthenticationServiceSelectionPlan> authenticationServiceSelectionPlan;
    @Autowired
    @Qualifier(value="proxy20Handler")
    private ObjectProvider<ProxyHandler> proxy20Handler;
    @Autowired
    @Qualifier(value="shibboleth.OpenSAMLConfig")
    private ObjectProvider<OpenSamlConfigBean> configBean;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private ObjectProvider<CentralAuthenticationService> centralAuthenticationService;
    @Autowired
    @Qualifier(value="authenticationAttributeReleasePolicy")
    private ObjectProvider<AuthenticationAttributeReleasePolicy> authenticationAttributeReleasePolicy;
    @Autowired
    @Qualifier(value="requestedContextValidator")
    private ObjectProvider<RequestedContextValidator> requestedContextValidator;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport;
    @Autowired
    @Qualifier(value="cas20WithoutProxyProtocolValidationSpecification")
    private ObjectProvider<CasProtocolValidationSpecification> cas20WithoutProxyProtocolValidationSpecification;
    @Autowired
    @Qualifier(value="serviceValidationAuthorizers")
    private ObjectProvider<ServiceTicketValidationAuthorizersExecutionPlan> validationAuthorizers;

    @ConditionalOnMissingBean(name={"casSamlServiceSuccessView"})
    @RefreshScope
    @Bean
    public View casSamlServiceSuccessView() {
        SamlCoreProperties samlCore = this.casProperties.getSamlCore();
        return new Saml10SuccessResponseView((ProtocolAttributeEncoder)this.protocolAttributeEncoder.getIfAvailable(), (ServicesManager)this.servicesManager.getIfAvailable(), this.saml10ObjectBuilder(), (ArgumentExtractor)this.argumentExtractor.getIfAvailable(), StandardCharsets.UTF_8.name(), samlCore.getSkewAllowance(), samlCore.getIssueLength(), samlCore.getIssuer(), samlCore.getAttributeNamespace(), (AuthenticationAttributeReleasePolicy)this.authenticationAttributeReleasePolicy.getIfAvailable(), (AuthenticationServiceSelectionPlan)this.authenticationServiceSelectionPlan.getIfAvailable(), (CasProtocolAttributesRenderer)new NoOpProtocolAttributesRenderer());
    }

    @ConditionalOnMissingBean(name={"casSamlServiceFailureView"})
    @RefreshScope
    @Bean
    public View casSamlServiceFailureView() {
        return new Saml10FailureResponseView((ProtocolAttributeEncoder)this.protocolAttributeEncoder.getIfAvailable(), (ServicesManager)this.servicesManager.getIfAvailable(), this.saml10ObjectBuilder(), (ArgumentExtractor)this.argumentExtractor.getIfAvailable(), StandardCharsets.UTF_8.name(), this.casProperties.getSamlCore().getSkewAllowance(), this.casProperties.getSamlCore().getIssueLength(), (AuthenticationAttributeReleasePolicy)this.authenticationAttributeReleasePolicy.getIfAvailable(), (AuthenticationServiceSelectionPlan)this.authenticationServiceSelectionPlan.getIfAvailable(), (CasProtocolAttributesRenderer)new NoOpProtocolAttributesRenderer());
    }

    @ConditionalOnMissingBean(name={"samlServiceResponseBuilder"})
    @Bean
    public ResponseBuilder samlServiceResponseBuilder() {
        return new SamlServiceResponseBuilder((ServicesManager)this.servicesManager.getIfAvailable());
    }

    @ConditionalOnMissingBean(name={"saml10ObjectBuilder"})
    @Bean
    public Saml10ObjectBuilder saml10ObjectBuilder() {
        return new Saml10ObjectBuilder((OpenSamlConfigBean)this.configBean.getIfAvailable());
    }

    @Bean
    public SamlValidateController samlValidateController() {
        return new SamlValidateController((CasProtocolValidationSpecification)this.cas20WithoutProxyProtocolValidationSpecification.getIfAvailable(), (AuthenticationSystemSupport)this.authenticationSystemSupport.getIfAvailable(), (ServicesManager)this.servicesManager.getIfAvailable(), (CentralAuthenticationService)this.centralAuthenticationService.getIfAvailable(), (ProxyHandler)this.proxy20Handler.getIfAvailable(), (ArgumentExtractor)this.argumentExtractor.getIfAvailable(), (RequestedContextValidator)this.requestedContextValidator.getIfAvailable(), (View)this.cas3ServiceJsonView.getIfAvailable(), this.casSamlServiceSuccessView(), this.casSamlServiceFailureView(), this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), (ServiceTicketValidationAuthorizersExecutionPlan)this.validationAuthorizers.getIfAvailable(), this.casProperties.getSso().isRenewAuthnEnabled());
    }
}

