/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.util;

import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.authentication.principal.SamlService;
import org.apereo.cas.support.saml.util.AbstractSamlObjectBuilder;
import org.apereo.cas.support.saml.util.CasHttpSoap11Encoder;
import org.apereo.cas.util.DateTimeUtils;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.Attribute;
import org.opensaml.saml.saml1.core.AttributeStatement;
import org.opensaml.saml.saml1.core.AttributeValue;
import org.opensaml.saml.saml1.core.Audience;
import org.opensaml.saml.saml1.core.AudienceRestrictionCondition;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.core.Conditions;
import org.opensaml.saml.saml1.core.ConfirmationMethod;
import org.opensaml.saml.saml1.core.NameIdentifier;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.core.Status;
import org.opensaml.saml.saml1.core.StatusCode;
import org.opensaml.saml.saml1.core.StatusMessage;
import org.opensaml.saml.saml1.core.Subject;
import org.opensaml.saml.saml1.core.SubjectConfirmation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Saml10ObjectBuilder
extends AbstractSamlObjectBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Saml10ObjectBuilder.class);
    private static final String CONFIRMATION_METHOD = "urn:oasis:names:tc:SAML:1.0:cm:artifact";
    private static final long serialVersionUID = -4711012620700270554L;

    public Saml10ObjectBuilder(OpenSamlConfigBean configBean) {
        super(configBean);
    }

    public Response newResponse(String id, ZonedDateTime issueInstant, String recipient, WebApplicationService service) {
        Response samlResponse = this.newSamlObject(Response.class);
        samlResponse.setID(id);
        samlResponse.setIssueInstant(DateTimeUtils.dateTimeOf((ChronoZonedDateTime)issueInstant));
        samlResponse.setVersion(SAMLVersion.VERSION_11);
        samlResponse.setInResponseTo(recipient);
        Saml10ObjectBuilder.setInResponseToForSamlResponseIfNeeded((Service)service, samlResponse);
        return samlResponse;
    }

    private static void setInResponseToForSamlResponseIfNeeded(Service service, Response samlResponse) {
        SamlService samlService;
        String requestId;
        if (service instanceof SamlService && StringUtils.isNotBlank((CharSequence)(requestId = (samlService = (SamlService)service).getRequestId()))) {
            samlResponse.setInResponseTo(requestId);
        }
    }

    public Assertion newAssertion(AuthenticationStatement authnStatement, String issuer, ZonedDateTime issuedAt, String id) {
        Assertion assertion = this.newSamlObject(Assertion.class);
        assertion.setID(id);
        assertion.setIssueInstant(DateTimeUtils.dateTimeOf((ChronoZonedDateTime)issuedAt));
        assertion.setIssuer(issuer);
        assertion.getAuthenticationStatements().add(authnStatement);
        return assertion;
    }

    public Conditions newConditions(ZonedDateTime issuedAt, String audienceUri, long issueLength) {
        Conditions conditions = this.newSamlObject(Conditions.class);
        conditions.setNotBefore(DateTimeUtils.dateTimeOf((ChronoZonedDateTime)issuedAt));
        conditions.setNotOnOrAfter(DateTimeUtils.dateTimeOf((ChronoZonedDateTime)issuedAt.plus(issueLength, ChronoUnit.SECONDS)));
        AudienceRestrictionCondition audienceRestriction = this.newSamlObject(AudienceRestrictionCondition.class);
        Audience audience = this.newSamlObject(Audience.class);
        audience.setUri(audienceUri);
        audienceRestriction.getAudiences().add(audience);
        conditions.getAudienceRestrictionConditions().add(audienceRestriction);
        return conditions;
    }

    public Status newStatus(QName codeValue) {
        return this.newStatus(codeValue, "");
    }

    public Status newStatus(QName codeValue, String statusMessage) {
        Status status = this.newSamlObject(Status.class);
        StatusCode code = this.newSamlObject(StatusCode.class);
        code.setValue(codeValue);
        status.setStatusCode(code);
        if (StringUtils.isNotBlank((CharSequence)statusMessage)) {
            StatusMessage message = this.newSamlObject(StatusMessage.class);
            message.setMessage(statusMessage);
            status.setStatusMessage(message);
        }
        return status;
    }

    public AuthenticationStatement newAuthenticationStatement(ZonedDateTime authenticationDate, Collection<Object> authenticationMethod, String subjectId) {
        AuthenticationStatement authnStatement = this.newSamlObject(AuthenticationStatement.class);
        authnStatement.setAuthenticationInstant(DateTimeUtils.dateTimeOf((ChronoZonedDateTime)authenticationDate));
        authnStatement.setAuthenticationMethod(authenticationMethod != null && !authenticationMethod.isEmpty() ? authenticationMethod.iterator().next().toString() : "urn:oasis:names:tc:SAML:1.0:am:unspecified");
        authnStatement.setSubject(this.newSubject(subjectId));
        return authnStatement;
    }

    public Subject newSubject(String identifier) {
        return this.newSubject(identifier, CONFIRMATION_METHOD);
    }

    public Subject newSubject(String identifier, String confirmationMethod) {
        SubjectConfirmation confirmation = this.newSamlObject(SubjectConfirmation.class);
        ConfirmationMethod method = this.newSamlObject(ConfirmationMethod.class);
        method.setConfirmationMethod(confirmationMethod);
        confirmation.getConfirmationMethods().add(method);
        NameIdentifier nameIdentifier = this.newSamlObject(NameIdentifier.class);
        nameIdentifier.setNameIdentifier(identifier);
        Subject subject = this.newSamlObject(Subject.class);
        subject.setNameIdentifier(nameIdentifier);
        subject.setSubjectConfirmation(confirmation);
        return subject;
    }

    public void addAttributeValuesToSaml1Attribute(String attributeName, Object attributeValue, List<XMLObject> attributeList) {
        this.addAttributeValuesToSamlAttribute(attributeName, attributeValue, attributeList, AttributeValue.DEFAULT_ELEMENT_NAME);
    }

    public AttributeStatement newAttributeStatement(Subject subject, Map<String, Object> attributes, String attributeNamespace) {
        AttributeStatement attrStatement = this.newSamlObject(AttributeStatement.class);
        attrStatement.setSubject(subject);
        for (Map.Entry<String, Object> e : attributes.entrySet()) {
            if (e.getValue() instanceof Collection && ((Collection)e.getValue()).isEmpty()) {
                LOGGER.info("Skipping attribute [{}] because it does not have any values.", (Object)e.getKey());
                continue;
            }
            Attribute attribute = this.newSamlObject(Attribute.class);
            attribute.setAttributeName(e.getKey());
            if (StringUtils.isNotBlank((CharSequence)attributeNamespace)) {
                attribute.setAttributeNamespace(attributeNamespace);
            }
            this.addAttributeValuesToSaml1Attribute(e.getKey(), e.getValue(), attribute.getAttributeValues());
            attrStatement.getAttributes().add(attribute);
        }
        return attrStatement;
    }

    public void encodeSamlResponse(HttpServletResponse httpResponse, HttpServletRequest httpRequest, Response samlMessage) throws Exception {
        SamlUtils.logSamlObject((OpenSamlConfigBean)this.configBean, (XMLObject)samlMessage);
        CasHttpSoap11Encoder encoder = new CasHttpSoap11Encoder();
        MessageContext context = new MessageContext();
        context.setMessage((Object)samlMessage);
        encoder.setHttpServletResponse(httpResponse);
        encoder.setMessageContext(context);
        encoder.initialize();
        encoder.prepareContext();
        encoder.encode();
    }
}

