/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationAttributeReleasePolicy;
import org.apereo.cas.authentication.AuthenticationContextValidator;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.MultifactorTriggerSelectionStrategy;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.principal.ResponseBuilder;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.saml.SamlCoreProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.authentication.principal.SamlServiceResponseBuilder;
import org.apereo.cas.support.saml.util.Saml10ObjectBuilder;
import org.apereo.cas.support.saml.web.SamlValidateController;
import org.apereo.cas.support.saml.web.view.Saml10FailureResponseView;
import org.apereo.cas.support.saml.web.view.Saml10SuccessResponseView;
import org.apereo.cas.ticket.proxy.ProxyHandler;
import org.apereo.cas.validation.CasProtocolValidationSpecification;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizersExecutionPlan;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.View;

@Configuration(value="samlConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SamlConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlConfiguration.class);
    @Autowired
    @Qualifier(value="argumentExtractor")
    private ObjectProvider<ArgumentExtractor> argumentExtractor;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="casAttributeEncoder")
    private ProtocolAttributeEncoder protocolAttributeEncoder;
    @Autowired
    @Qualifier(value="cas3ServiceJsonView")
    private View cas3ServiceJsonView;
    @Autowired
    @Qualifier(value="proxy20Handler")
    private ProxyHandler proxy20Handler;
    @Autowired
    @Qualifier(value="shibboleth.OpenSAMLConfig")
    private OpenSamlConfigBean configBean;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired
    @Qualifier(value="authenticationAttributeReleasePolicy")
    private AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy;
    @Autowired
    @Qualifier(value="authenticationContextValidator")
    private AuthenticationContextValidator authenticationContextValidator;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport;
    @Autowired
    @Qualifier(value="cas20WithoutProxyProtocolValidationSpecification")
    private CasProtocolValidationSpecification cas20WithoutProxyProtocolValidationSpecification;
    @Autowired
    @Qualifier(value="defaultMultifactorTriggerSelectionStrategy")
    private MultifactorTriggerSelectionStrategy multifactorTriggerSelectionStrategy;
    @Autowired
    @Qualifier(value="serviceValidationAuthorizers")
    private ServiceTicketValidationAuthorizersExecutionPlan validationAuthorizers;

    @ConditionalOnMissingBean(name={"casSamlServiceSuccessView"})
    @RefreshScope
    @Bean
    public View casSamlServiceSuccessView() {
        SamlCoreProperties samlCore = this.casProperties.getSamlCore();
        return new Saml10SuccessResponseView(this.protocolAttributeEncoder, this.servicesManager, this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.saml10ObjectBuilder(), (ArgumentExtractor)this.argumentExtractor.getIfAvailable(), StandardCharsets.UTF_8.name(), samlCore.getSkewAllowance(), samlCore.getIssueLength(), samlCore.getIssuer(), samlCore.getAttributeNamespace(), this.authenticationAttributeReleasePolicy);
    }

    @ConditionalOnMissingBean(name={"casSamlServiceFailureView"})
    @RefreshScope
    @Bean
    public View casSamlServiceFailureView() {
        return new Saml10FailureResponseView(this.protocolAttributeEncoder, this.servicesManager, this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.saml10ObjectBuilder(), (ArgumentExtractor)this.argumentExtractor.getIfAvailable(), StandardCharsets.UTF_8.name(), this.casProperties.getSamlCore().getSkewAllowance(), this.casProperties.getSamlCore().getIssueLength(), this.authenticationAttributeReleasePolicy);
    }

    @ConditionalOnMissingBean(name={"samlServiceResponseBuilder"})
    @Bean
    public ResponseBuilder samlServiceResponseBuilder() {
        return new SamlServiceResponseBuilder(this.servicesManager);
    }

    @ConditionalOnMissingBean(name={"saml10ObjectBuilder"})
    @Bean
    public Saml10ObjectBuilder saml10ObjectBuilder() {
        return new Saml10ObjectBuilder(this.configBean);
    }

    @Bean
    public SamlValidateController samlValidateController() {
        return new SamlValidateController(this.cas20WithoutProxyProtocolValidationSpecification, this.authenticationSystemSupport, this.servicesManager, this.centralAuthenticationService, this.proxy20Handler, (ArgumentExtractor)this.argumentExtractor.getIfAvailable(), this.multifactorTriggerSelectionStrategy, this.authenticationContextValidator, this.cas3ServiceJsonView, this.casSamlServiceSuccessView(), this.casSamlServiceFailureView(), this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.validationAuthorizers, this.casProperties.getSso().isRenewAuthnEnabled());
    }
}

