/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.view;

import java.net.MalformedURLException;
import java.net.URL;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.web.view.AbstractCasView;
import org.apereo.cas.support.saml.util.Saml10ObjectBuilder;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.opensaml.saml.saml1.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSaml10ResponseView
extends AbstractCasView {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSaml10ResponseView.class);
    protected final Saml10ObjectBuilder samlObjectBuilder;
    protected final int skewAllowance;
    protected final int issueLength;
    private final ArgumentExtractor samlArgumentExtractor;
    private final String encoding;

    public AbstractSaml10ResponseView(boolean successResponse, ProtocolAttributeEncoder protocolAttributeEncoder, ServicesManager servicesManager, String authenticationContextAttribute, Saml10ObjectBuilder samlObjectBuilder, ArgumentExtractor samlArgumentExtractor, String encoding, int skewAllowance, int issueLength) {
        super(successResponse, protocolAttributeEncoder, servicesManager, authenticationContextAttribute);
        this.samlObjectBuilder = samlObjectBuilder;
        this.samlArgumentExtractor = samlArgumentExtractor;
        this.encoding = encoding;
        this.issueLength = issueLength;
        LOGGER.trace("Using [{}] seconds as skew allowance.", (Object)skewAllowance);
        this.skewAllowance = skewAllowance;
    }

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String serviceId = null;
        try {
            response.setCharacterEncoding(this.encoding);
            WebApplicationService service = this.samlArgumentExtractor.extractService(request);
            if (service == null || StringUtils.isBlank((CharSequence)service.getId())) {
                serviceId = "UNKNOWN";
            } else {
                try {
                    serviceId = new URL(service.getId()).getHost();
                }
                catch (MalformedURLException e) {
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                }
            }
            LOGGER.debug("Using [{}] as the recipient of the SAML response for [{}]", (Object)serviceId, (Object)service);
            Response samlResponse = this.samlObjectBuilder.newResponse(this.samlObjectBuilder.generateSecureRandomId(), ZonedDateTime.now(ZoneOffset.UTC).minusSeconds(this.skewAllowance), serviceId, service);
            LOGGER.debug("Created SAML response for service [{}]", (Object)serviceId);
            this.prepareResponse(samlResponse, model);
            LOGGER.debug("Starting to encode SAML response for service [{}]", (Object)serviceId);
            this.samlObjectBuilder.encodeSamlResponse(response, request, samlResponse);
        }
        catch (Exception e) {
            LOGGER.error("Error generating SAML response for service [{}].", serviceId, (Object)e);
            throw e;
        }
    }

    protected abstract void prepareResponse(Response var1, Map<String, Object> var2);
}

