/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationContextValidator;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.MultifactorTriggerSelectionStrategy;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.principal.ResponseBuilder;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.authentication.principal.SamlServiceFactory;
import org.apereo.cas.support.saml.authentication.principal.SamlServiceResponseBuilder;
import org.apereo.cas.support.saml.util.Saml10ObjectBuilder;
import org.apereo.cas.support.saml.web.SamlValidateController;
import org.apereo.cas.support.saml.web.view.Saml10FailureResponseView;
import org.apereo.cas.support.saml.web.view.Saml10SuccessResponseView;
import org.apereo.cas.ticket.proxy.ProxyHandler;
import org.apereo.cas.validation.CasProtocolValidationSpecification;
import org.apereo.cas.validation.ValidationAuthorizer;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.DefaultArgumentExtractor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.View;

@Configuration(value="samlConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SamlConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="casAttributeEncoder")
    private ProtocolAttributeEncoder protocolAttributeEncoder;
    @Autowired
    @Qualifier(value="cas3ServiceJsonView")
    private View cas3ServiceJsonView;
    @Autowired
    @Qualifier(value="proxy20Handler")
    private ProxyHandler proxy20Handler;
    @Autowired
    @Qualifier(value="shibboleth.OpenSAMLConfig")
    private OpenSamlConfigBean configBean;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired
    @Qualifier(value="authenticationContextValidator")
    private AuthenticationContextValidator authenticationContextValidator;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport;
    @Autowired
    @Qualifier(value="cas20WithoutProxyProtocolValidationSpecification")
    private CasProtocolValidationSpecification cas20WithoutProxyProtocolValidationSpecification;
    @Autowired
    @Qualifier(value="defaultMultifactorTriggerSelectionStrategy")
    private MultifactorTriggerSelectionStrategy multifactorTriggerSelectionStrategy;
    @Autowired
    @Qualifier(value="serviceValidationAuthorizers")
    private Set<ValidationAuthorizer> validationAuthorizers;

    @ConditionalOnMissingBean(name={"casSamlServiceSuccessView"})
    @RefreshScope
    @Bean
    public View casSamlServiceSuccessView() {
        return new Saml10SuccessResponseView(this.protocolAttributeEncoder, this.servicesManager, this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.saml10ObjectBuilder(), (ArgumentExtractor)new DefaultArgumentExtractor((ServiceFactory)new SamlServiceFactory()), StandardCharsets.UTF_8.name(), this.casProperties.getSamlCore().getSkewAllowance(), this.casProperties.getSamlCore().getIssueLength(), this.casProperties.getSamlCore().getIssuer(), this.casProperties.getSamlCore().getAttributeNamespace());
    }

    @ConditionalOnMissingBean(name={"casSamlServiceFailureView"})
    @RefreshScope
    @Bean
    public View casSamlServiceFailureView() {
        return new Saml10FailureResponseView(this.protocolAttributeEncoder, this.servicesManager, this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.saml10ObjectBuilder(), (ArgumentExtractor)new DefaultArgumentExtractor((ServiceFactory)new SamlServiceFactory()), StandardCharsets.UTF_8.name(), this.casProperties.getSamlCore().getSkewAllowance(), this.casProperties.getSamlCore().getIssueLength());
    }

    @ConditionalOnMissingBean(name={"samlServiceResponseBuilder"})
    @Bean
    public ResponseBuilder samlServiceResponseBuilder() {
        return new SamlServiceResponseBuilder();
    }

    @ConditionalOnMissingBean(name={"saml10ObjectBuilder"})
    @Bean
    public Saml10ObjectBuilder saml10ObjectBuilder() {
        return new Saml10ObjectBuilder(this.configBean);
    }

    @Autowired
    @Bean
    public SamlValidateController samlValidateController(@Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor) {
        return new SamlValidateController(this.cas20WithoutProxyProtocolValidationSpecification, this.authenticationSystemSupport, this.servicesManager, this.centralAuthenticationService, this.proxy20Handler, argumentExtractor, this.multifactorTriggerSelectionStrategy, this.authenticationContextValidator, this.cas3ServiceJsonView, this.casSamlServiceSuccessView(), this.casSamlServiceFailureView(), this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.validationAuthorizers);
    }
}

