/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config.authentication.support;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.saml.authentication.principal.SamlService;
import org.apereo.cas.support.saml.util.SamlCompliantUniqueTicketIdGenerator;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.UniqueTicketIdGeneratorConfigurer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="samlUniqueTicketIdGeneratorConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SamlUniqueTicketIdGeneratorConfiguration
implements UniqueTicketIdGeneratorConfigurer {
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean
    public UniqueTicketIdGenerator samlServiceTicketUniqueIdGenerator() {
        SamlCompliantUniqueTicketIdGenerator gen = new SamlCompliantUniqueTicketIdGenerator(this.casProperties.getServer().getName());
        gen.setSaml2compliant(this.casProperties.getSamlCore().isTicketidSaml2());
        return gen;
    }

    public Collection<Pair<String, UniqueTicketIdGenerator>> buildUniqueTicketIdGenerators() {
        return Collections.singleton(Pair.of((Object)SamlService.class.getCanonicalName(), (Object)this.samlServiceTicketUniqueIdGenerator()));
    }
}

