/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apereo.cas.adaptors.rest.RestAuthenticationApi;
import org.apereo.cas.adaptors.rest.RestAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.support.rest.RestAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration(value="casRestAuthenticationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasRestAuthenticationConfiguration {
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="personDirectoryPrincipalResolver")
    private PrincipalResolver personDirectoryPrincipalResolver;
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean
    @RefreshScope
    public RestTemplate restAuthenticationTemplate() {
        try {
            URI casHost = new URI(this.casProperties.getServer().getName());
            HttpHost host = new HttpHost(casHost.getHost(), casHost.getPort(), casHost.getScheme());
            HttpComponentsClientHttpRequestFactoryBasicAuth factory = new HttpComponentsClientHttpRequestFactoryBasicAuth(host);
            return new RestTemplate((ClientHttpRequestFactory)factory);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @ConditionalOnMissingBean(name={"restAuthenticationPrincipalFactory"})
    @Bean
    @RefreshScope
    public PrincipalFactory restAuthenticationPrincipalFactory() {
        return new DefaultPrincipalFactory();
    }

    @ConditionalOnMissingBean(name={"restAuthenticationApi"})
    @Bean
    @RefreshScope
    public RestAuthenticationApi restAuthenticationApi() {
        return new RestAuthenticationApi(this.restAuthenticationTemplate(), this.casProperties.getAuthn().getRest().getUri());
    }

    @Bean
    @RefreshScope
    public AuthenticationHandler restAuthenticationHandler() {
        RestAuthenticationProperties rest = this.casProperties.getAuthn().getRest();
        RestAuthenticationHandler r = new RestAuthenticationHandler(rest.getName(), this.restAuthenticationApi(), this.servicesManager, this.restAuthenticationPrincipalFactory());
        r.setPasswordEncoder(PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)rest.getPasswordEncoder()));
        return r;
    }

    @ConditionalOnMissingBean(name={"casRestAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer casRestAuthenticationEventExecutionPlanConfigurer() {
        return plan -> {
            if (StringUtils.isNotBlank((CharSequence)this.casProperties.getAuthn().getRest().getUri())) {
                plan.registerAuthenticationHandlerWithPrincipalResolver(this.restAuthenticationHandler(), this.personDirectoryPrincipalResolver);
            }
        };
    }

    private static class HttpComponentsClientHttpRequestFactoryBasicAuth
    extends HttpComponentsClientHttpRequestFactory {
        private final HttpHost host;

        HttpComponentsClientHttpRequestFactoryBasicAuth(HttpHost host) {
            this.host = host;
        }

        protected HttpContext createHttpContext(HttpMethod httpMethod, URI uri) {
            return this.createHttpContext();
        }

        private HttpContext createHttpContext() {
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(this.host, (AuthScheme)basicAuth);
            BasicHttpContext localcontext = new BasicHttpContext();
            localcontext.setAttribute("http.auth.auth-cache", (Object)authCache);
            return localcontext;
        }
    }
}

