/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.rest;

import java.nio.charset.Charset;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.SimplePrincipal;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.EncodingUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestAuthenticationApi {
    private final RestTemplate restTemplate;
    private final String authenticationUri;

    public RestAuthenticationApi(RestTemplate restTemplate, String authenticationUri) {
        this.restTemplate = restTemplate;
        this.authenticationUri = authenticationUri;
    }

    public ResponseEntity<SimplePrincipal> authenticate(UsernamePasswordCredential c) {
        HttpEntity entity = new HttpEntity((MultiValueMap)RestAuthenticationApi.createHeaders(c));
        return this.restTemplate.exchange(this.authenticationUri, HttpMethod.POST, entity, SimplePrincipal.class, new Object[0]);
    }

    public static HttpHeaders createHeaders(UsernamePasswordCredential c) {
        HttpHeaders acceptHeaders = new HttpHeaders();
        acceptHeaders.setAccept(CollectionUtils.wrap((Object)MediaType.APPLICATION_JSON));
        String authorization = c.getUsername() + ':' + c.getPassword();
        String basic = EncodingUtils.encodeBase64((byte[])authorization.getBytes(Charset.forName("US-ASCII")));
        acceptHeaders.set("Authorization", "Basic " + basic);
        return acceptHeaders;
    }
}

