/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.pm.InvalidPasswordException;
import org.apereo.cas.pm.PasswordChangeBean;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.PasswordValidationService;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class PasswordChangeAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordChangeAction.class);
    public static final String PASSWORD_UPDATE_SUCCESS = "passwordUpdateSuccess";
    private static final String PASSWORD_VALIDATION_FAILURE_CODE = "pm.validationFailure";
    private static final String DEFAULT_MESSAGE = "Could not update the account password";
    private static final MessageBuilder ERROR_MSG_BUILDER = new MessageBuilder().error();
    private final PasswordManagementService passwordManagementService;
    private final PasswordValidationService passwordValidationService;

    protected Event doExecute(RequestContext requestContext) {
        try {
            UsernamePasswordCredential c = (UsernamePasswordCredential)WebUtils.getCredential((RequestContext)requestContext);
            PasswordChangeBean bean = (PasswordChangeBean)requestContext.getFlowScope().get("password", PasswordChangeBean.class);
            if (!this.passwordValidationService.isValid(c, bean)) {
                return this.getErrorEvent(requestContext, PASSWORD_VALIDATION_FAILURE_CODE, DEFAULT_MESSAGE, new Object[0]);
            }
            if (this.passwordManagementService.change((Credential)c, bean)) {
                WebUtils.putCredential((RequestContext)requestContext, (Credential)new UsernamePasswordCredential(c.getUsername(), bean.getPassword()));
                return new EventFactorySupport().event((Object)this, PASSWORD_UPDATE_SUCCESS);
            }
        }
        catch (InvalidPasswordException e) {
            return this.getErrorEvent(requestContext, PASSWORD_VALIDATION_FAILURE_CODE + (String)StringUtils.defaultIfBlank((CharSequence)e.getCode(), (CharSequence)""), (String)StringUtils.defaultIfBlank((CharSequence)e.getValidationMessage(), (CharSequence)DEFAULT_MESSAGE), e.getParams());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return this.getErrorEvent(requestContext, "pm.updateFailure", DEFAULT_MESSAGE, new Object[0]);
    }

    private Event getErrorEvent(RequestContext ctx, String code, String message, Object ... params) {
        ctx.getMessageContext().addMessage(ERROR_MSG_BUILDER.code(code).defaultText(message).args(params).build());
        return this.error();
    }

    @Generated
    public PasswordChangeAction(PasswordManagementService passwordManagementService, PasswordValidationService passwordValidationService) {
        this.passwordManagementService = passwordManagementService;
        this.passwordValidationService = passwordValidationService;
    }
}

