/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.flow;

import java.io.Serializable;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.flow.services.DefaultRegisteredServiceUserInterfaceInfo;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class OidcRegisteredServiceUIAction
extends AbstractAction
implements Serializable {
    private static final long serialVersionUID = -8016284160122109307L;
    private final transient ServicesManager servicesManager;
    private final transient AuthenticationServiceSelectionStrategy serviceSelectionStrategy;

    public OidcRegisteredServiceUIAction(ServicesManager servicesManager, AuthenticationServiceSelectionStrategy serviceSelectionStrategy) {
        this.servicesManager = servicesManager;
        this.serviceSelectionStrategy = serviceSelectionStrategy;
    }

    protected Event doExecute(RequestContext requestContext) {
        WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
        if (service != null) {
            service = this.serviceSelectionStrategy.resolveServiceFrom((Service)service);
            RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)service, (RegisteredService)registeredService);
            if (registeredService instanceof OidcRegisteredService) {
                OidcRegisteredService oauthService = (OidcRegisteredService)OidcRegisteredService.class.cast(registeredService);
                WebUtils.putServiceUserInterfaceMetadata((RequestContext)requestContext, (Serializable)new DefaultRegisteredServiceUserInterfaceInfo((RegisteredService)oauthService));
            }
        }
        return this.success();
    }
}

