/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.validator.OAuth20Validator;
import org.apereo.cas.support.oauth.web.endpoints.BaseOAuth20Controller;
import org.apereo.cas.ticket.accesstoken.AccessTokenFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.jooq.lambda.Unchecked;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;

public class OidcJwksEndpointController
extends BaseOAuth20Controller {
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcJwksEndpointController.class);
    @Autowired
    private ResourceLoader resourceLoader;
    private final Resource jwksFile;

    public OidcJwksEndpointController(ServicesManager servicesManager, TicketRegistry ticketRegistry, OAuth20Validator validator, AccessTokenFactory accessTokenFactory, PrincipalFactory principalFactory, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory, OAuth20ProfileScopeToAttributesFilter scopeToAttributesFilter, CasConfigurationProperties casProperties, CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator) {
        super(servicesManager, ticketRegistry, validator, accessTokenFactory, principalFactory, webApplicationServiceServiceFactory, scopeToAttributesFilter, casProperties, ticketGrantingTicketCookieGenerator);
        this.jwksFile = casProperties.getAuthn().getOidc().getJwksFile();
    }

    @GetMapping(value={"/oidc/jwks"}, produces={"application/json"})
    public ResponseEntity<String> handleRequestInternal(HttpServletRequest request, HttpServletResponse response, Model model) {
        Assert.notNull((Object)this.jwksFile, (String)"JWKS file cannot be undefined or null.");
        try {
            String jsonJwks = IOUtils.toString((InputStream)this.jwksFile.getInputStream(), (Charset)StandardCharsets.UTF_8);
            JsonWebKeySet jsonWebKeySet = new JsonWebKeySet(jsonJwks);
            this.servicesManager.getAllServices().stream().filter(s -> s instanceof OidcRegisteredService && StringUtils.isNotBlank((CharSequence)((OidcRegisteredService)s).getJwks())).forEach(Unchecked.consumer(s -> {
                OidcRegisteredService service = (OidcRegisteredService)s;
                Resource resource = this.resourceLoader.getResource(service.getJwks());
                JsonWebKeySet set = new JsonWebKeySet(IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8));
                set.getJsonWebKeys().forEach(arg_0 -> ((JsonWebKeySet)jsonWebKeySet).addJsonWebKey(arg_0));
            }));
            String body = jsonWebKeySet.toJson(JsonWebKey.OutputControlLevel.PUBLIC_ONLY);
            response.setContentType("application/json");
            return new ResponseEntity((Object)body, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.BAD_REQUEST);
        }
    }
}

