/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.support.oauth.web.OAuth20HandlerInterceptorAdapter;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.BaseAccessTokenGrantRequestExtractor;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class OidcHandlerInterceptorAdapter
extends OAuth20HandlerInterceptorAdapter {
    private final HandlerInterceptorAdapter requiresAuthenticationDynamicRegistrationInterceptor;
    private final OidcConstants.DynamicClientRegistrationMode dynamicClientRegistrationMode;
    private final Collection<BaseAccessTokenGrantRequestExtractor> accessTokenGrantRequestExtractors;

    public OidcHandlerInterceptorAdapter(HandlerInterceptorAdapter requiresAuthenticationAccessTokenInterceptor, HandlerInterceptorAdapter requiresAuthenticationAuthorizeInterceptor, HandlerInterceptorAdapter requiresAuthenticationDynamicRegistrationInterceptor, OidcConstants.DynamicClientRegistrationMode dynamicClientRegistrationMode, Collection<BaseAccessTokenGrantRequestExtractor> accessTokenGrantRequestExtractors) {
        super(requiresAuthenticationAccessTokenInterceptor, requiresAuthenticationAuthorizeInterceptor, accessTokenGrantRequestExtractors);
        this.requiresAuthenticationDynamicRegistrationInterceptor = requiresAuthenticationDynamicRegistrationInterceptor;
        this.dynamicClientRegistrationMode = dynamicClientRegistrationMode;
        this.accessTokenGrantRequestExtractors = accessTokenGrantRequestExtractors;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!super.preHandle(request, response, handler)) {
            return false;
        }
        if (this.isDynamicClientRegistrationRequest(request.getRequestURI()) && this.isDynamicClientRegistrationRequestProtected()) {
            return this.requiresAuthenticationDynamicRegistrationInterceptor.preHandle(request, response, handler);
        }
        return true;
    }

    private boolean isDynamicClientRegistrationRequestProtected() {
        return this.dynamicClientRegistrationMode == OidcConstants.DynamicClientRegistrationMode.PROTECTED;
    }

    protected boolean isDynamicClientRegistrationRequest(String requestPath) {
        return this.doesUriMatchPattern(requestPath, "register");
    }
}

