/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.util.Optional;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.oidc.util.OidcAuthorizationRequestSupport;
import org.apereo.cas.support.oauth.web.response.OAuth20DefaultCasClientRedirectActionBuilder;
import org.pac4j.cas.client.CasClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.redirect.RedirectAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcCasClientRedirectActionBuilder
extends OAuth20DefaultCasClientRedirectActionBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcCasClientRedirectActionBuilder.class);
    private final OidcAuthorizationRequestSupport oidcAuthorizationRequestSupport;

    public OidcCasClientRedirectActionBuilder(OidcAuthorizationRequestSupport oidcAuthorizationRequestSupport) {
        this.oidcAuthorizationRequestSupport = oidcAuthorizationRequestSupport;
    }

    public RedirectAction build(CasClient casClient, WebContext context) {
        Optional<Authentication> auth = this.oidcAuthorizationRequestSupport.isCasAuthenticationAvailable(context);
        auth.ifPresent(authentication -> this.oidcAuthorizationRequestSupport.configureClientForMaxAgeAuthorizationRequest(casClient, context, (Authentication)authentication));
        OidcAuthorizationRequestSupport.configureClientForPromptLoginAuthorizationRequest(casClient, context);
        OidcAuthorizationRequestSupport.configureClientForPromptNoneAuthorizationRequest(casClient, context);
        RedirectAction action = super.build(casClient, context);
        LOGGER.debug("Final redirect action is [{}]", (Object)action);
        return action;
    }
}

