/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks;

import com.github.benmanes.caffeine.cache.CacheLoader;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.services.OidcRegisteredService;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.RsaJsonWebKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class OidcServiceJsonWebKeystoreCacheLoader
implements CacheLoader<OidcRegisteredService, Optional<RsaJsonWebKey>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcServiceJsonWebKeystoreCacheLoader.class);
    @Autowired
    private ResourceLoader resourceLoader;

    public Optional<RsaJsonWebKey> load(OidcRegisteredService svc) throws Exception {
        Optional<JsonWebKeySet> jwks = this.buildJsonWebKeySet(svc);
        if (!jwks.isPresent() || jwks.get().getJsonWebKeys().isEmpty()) {
            return Optional.empty();
        }
        RsaJsonWebKey key = OidcServiceJsonWebKeystoreCacheLoader.getJsonSigningWebKeyFromJwks(jwks.get());
        if (key == null) {
            return Optional.empty();
        }
        return Optional.of(key);
    }

    private static RsaJsonWebKey getJsonSigningWebKeyFromJwks(JsonWebKeySet jwks) {
        if (jwks.getJsonWebKeys().isEmpty()) {
            LOGGER.warn("No JSON web keys are available in the keystore");
            return null;
        }
        RsaJsonWebKey key = (RsaJsonWebKey)jwks.getJsonWebKeys().get(0);
        if (StringUtils.isBlank((CharSequence)key.getAlgorithm())) {
            LOGGER.warn("Located JSON web key [{}] has no algorithm defined", (Object)key);
        }
        if (StringUtils.isBlank((CharSequence)key.getKeyId())) {
            LOGGER.warn("Located JSON web key [{}] has no key id defined", (Object)key);
        }
        if (key.getPublicKey() == null) {
            LOGGER.warn("Located JSON web key [{}] has no public key", (Object)key);
            return null;
        }
        return key;
    }

    private Optional<JsonWebKeySet> buildJsonWebKeySet(OidcRegisteredService service) {
        try {
            LOGGER.debug("Loading JSON web key from [{}]", (Object)service.getJwks());
            Resource resource = this.resourceLoader.getResource(service.getJwks());
            JsonWebKeySet jsonWebKeySet = OidcServiceJsonWebKeystoreCacheLoader.buildJsonWebKeySet(resource);
            if (jsonWebKeySet == null || jsonWebKeySet.getJsonWebKeys().isEmpty()) {
                LOGGER.warn("No JSON web keys could be found for [{}]", (Object)service);
                return Optional.empty();
            }
            long badKeysCount = jsonWebKeySet.getJsonWebKeys().stream().filter(k -> StringUtils.isBlank((CharSequence)k.getAlgorithm()) && StringUtils.isBlank((CharSequence)k.getKeyId()) && StringUtils.isBlank((CharSequence)k.getKeyType())).count();
            if (badKeysCount == (long)jsonWebKeySet.getJsonWebKeys().size()) {
                LOGGER.warn("No valid JSON web keys could be found for [{}]", (Object)service);
                return Optional.empty();
            }
            RsaJsonWebKey webKey = OidcServiceJsonWebKeystoreCacheLoader.getJsonSigningWebKeyFromJwks(jsonWebKeySet);
            if (webKey.getPublicKey() == null) {
                LOGGER.warn("JSON web key retrieved [{}] has no associated public key", (Object)webKey.getKeyId());
                return Optional.empty();
            }
            return Optional.of(jsonWebKeySet);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    private static JsonWebKeySet buildJsonWebKeySet(Resource resource) throws Exception {
        LOGGER.debug("Loading JSON web key from [{}]", (Object)resource);
        String json = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
        LOGGER.debug("Retrieved JSON web key from [{}] as [{}]", (Object)resource, (Object)json);
        return OidcServiceJsonWebKeystoreCacheLoader.buildJsonWebKeySet(json);
    }

    private static JsonWebKeySet buildJsonWebKeySet(String json) throws Exception {
        JsonWebKeySet jsonWebKeySet = new JsonWebKeySet(json);
        RsaJsonWebKey webKey = OidcServiceJsonWebKeystoreCacheLoader.getJsonSigningWebKeyFromJwks(jsonWebKeySet);
        if (webKey == null || webKey.getPublicKey() == null) {
            LOGGER.warn("JSON web key retrieved [{}] is not found or has no associated public key", (Object)webKey);
            return null;
        }
        return jsonWebKeySet;
    }
}

